package com.macrofocus.application.root

import org.mkui.component.CPComponent
import java.awt.*
import java.awt.datatransfer.DataFlavor
import java.awt.datatransfer.UnsupportedFlavorException
import java.awt.font.FontRenderContext
import java.awt.font.TextLayout
import java.awt.geom.AffineTransform
import java.awt.geom.Point2D
import java.awt.geom.Rectangle2D
import java.awt.geom.RoundRectangle2D
import java.io.File
import java.io.IOException
import javax.swing.*

class CPDragDropHere(target: JComponent) : CPComponent {
    val panel: JComponent
    private val content: JPanel

    private var listeners: MutableList<Listener> = ArrayList<Listener>()

    interface Listener {
        fun filesDropped(files: Iterable<File?>?)
    }

    fun addListener(listener: Listener) {
        listeners.add(listener)
    }

    override val nativeComponent: JComponent
        get() = panel

    fun configure(target: JComponent) {
        target.transferHandler = object : TransferHandler() {
            override fun canImport(supp: TransferSupport): Boolean {
                /* for the demo, we'll only support drops (not clipboard paste) */
                return if (!supp.isDrop) {
                    false
                } else supp.isDataFlavorSupported(DataFlavor.javaFileListFlavor)

                /* return true if and only if the drop contains a list of files */
            }

            override fun importData(support: TransferSupport): Boolean {
                if (!canImport(support)) {
                    return false
                }

                /* fetch the Transferable */
                val t = support.transferable
                try {
                    /* fetch the data from the Transferable */
                    val data = t.getTransferData(DataFlavor.javaFileListFlavor)

                    /* data of type javaFileListFlavor is a list of files */
                    val fileList = data as List<File>
                    for (listener in listeners) {
                        listener.filesDropped(fileList)
                    }
                } catch (e: UnsupportedFlavorException) {
                    return false
                } catch (e: IOException) {
                    return false
                }
                return true
            }
        }
    }

    fun addComponent(component: JComponent?) {
//        component.setAlignmentX(CENTER_ALIGNMENT);
        content.add(component)
    }

    inner class DragHereIcon : Icon {
        private val size = 80
        private val a = 4f
        private val b = 8f
        private val r = 16
        private val f = size / 4
        private val font = Font("Monospace", Font.PLAIN, size)
        private val frc = FontRenderContext(null, true, true)
        private val s = TextLayout("\u21E9", font, frc).getOutline(null)
        private val linec = Color.GRAY
        override fun paintIcon(c: Component, g: Graphics, x: Int, y: Int) {
            val g2 = g.create() as Graphics2D
            g2.setRenderingHint(
                RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON
            )
            g2.translate(x, y)
            g2.stroke = BasicStroke(a)
            g2.paint = linec
            g2.draw(
                RoundRectangle2D.Float(
                    a, a, size - 2 * a - 1, size - 2 * a - 1, r.toFloat(),
                    r.toFloat()
                )
            )
            g2.stroke = BasicStroke(b)
            g2.color = UIManager.getColor("Panel.background")
            g2.drawLine(1 * f, 0 * f, 1 * f, 4 * f)
            g2.drawLine(2 * f, 0 * f, 2 * f, 4 * f)
            g2.drawLine(3 * f, 0 * f, 3 * f, 4 * f)
            g2.drawLine(0 * f, 1 * f, 4 * f, 1 * f)
            g2.drawLine(0 * f, 2 * f, 4 * f, 2 * f)
            g2.drawLine(0 * f, 3 * f, 4 * f, 3 * f)
            g2.paint = linec
            val b: Rectangle2D = s.bounds
            val p = Point2D.Double(
                b.x + b.width / 2.0, b.y + b.height / 2.0
            )
            val toCenterAT = AffineTransform.getTranslateInstance(
                size / 2.0 - p.getX(), size / 2.0 - p.getY()
            )
            g2.fill(toCenterAT.createTransformedShape(s))
            g2.translate(-x, -y)
            g2.dispose()
        }

        override fun getIconWidth(): Int {
            return size
        }

        override fun getIconHeight(): Int {
            return size
        }
    }

    init {
        val icon: JLabel = JLabel(DragHereIcon())
        val label = JLabel()
        label.text = "<html>Drag <b>file</b> here"
        label.verticalTextPosition = SwingConstants.BOTTOM
        label.horizontalTextPosition = SwingConstants.CENTER
        label.foreground = Color.GRAY
        label.font = Font("Monospace", Font.PLAIN, 24)
        content = JPanel()
        content.layout = VerticalFlowLayout()
        content.add(label)
        content.add(icon)
        panel = JPanel(BorderLayout())
        panel.add(content, BorderLayout.CENTER)
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8))
        configure(target)
    }
}
