/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.file;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.application.file.AbstractFileFilter;
import com.macrofocus.application.file.MFileChooser;
import com.macrofocus.common.file.CPFile;
import com.macrofocus.common.file.FileType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.window.CPWindow;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001f\u0010\u0010\u001a\u00020\f2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0012\"\u00020\t\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u001f\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010\u0015J\u0010\u0010!\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u0004\u0018\u00010\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006#"}, d2={"Lcom/macrofocus/application/file/CPFileChooser;", "", "<init>", "()V", "fileChooser", "Ljavax/swing/JFileChooser;", "map", "", "Ljavax/swing/filechooser/FileFilter;", "Lcom/macrofocus/common/file/FileType;", "reverseMap", "SwingFileChooser", "", "setTitle", "title", "", "setFileTypes", "fileTypes", "", "([Lcom/macrofocus/common/file/FileType;)V", "showOpenDialog", "Lcom/macrofocus/common/file/CPFile;", "window", "Lorg/mkui/window/CPWindow;", "showSaveDialog", "value", "selectedFileType", "getSelectedFileType", "()Lcom/macrofocus/common/file/FileType;", "setSelectedFileType", "(Lcom/macrofocus/common/file/FileType;)V", "setCurrentDirectory", "currentDirectory", "setSelectedFile", "selectedFile", "macrofocus-application"})
@StabilityInferred(parameters=0)
public final class CPFileChooser {
    @Nullable
    private JFileChooser fileChooser;
    @NotNull
    private final Map<FileFilter, FileType> map = new HashMap();
    @NotNull
    private final Map<FileType, FileFilter> reverseMap = new HashMap();
    public static final int $stable = 8;

    public final void SwingFileChooser() {
        JFileChooser jFileChooser = this.fileChooser = (JFileChooser)new MFileChooser();
        Intrinsics.checkNotNull((Object)jFileChooser);
        jFileChooser.setFileSelectionMode(0);
        JFileChooser jFileChooser2 = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser2);
        jFileChooser2.setAcceptAllFileFilterUsed(false);
        JFileChooser jFileChooser3 = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser3);
        jFileChooser3.setControlButtonsAreShown(true);
    }

    public final void setTitle(@Nullable String title) {
        JFileChooser jFileChooser = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser);
        jFileChooser.setDialogTitle(title);
    }

    public final void setFileTypes(FileType ... fileTypes) {
        Intrinsics.checkNotNullParameter((Object)fileTypes, (String)"fileTypes");
        JFileChooser jFileChooser = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser);
        jFileChooser.resetChoosableFileFilters();
        this.map.clear();
        this.reverseMap.clear();
        FileFilter first = null;
        for (FileType fileType : fileTypes) {
            String[] extensionFilters = new String[fileType.getExtensions().length];
            int n = extensionFilters.length;
            for (int i = 0; i < n; ++i) {
                extensionFilters[i] = "*." + fileType.getExtensions()[i];
            }
            FileFilter filter2 = new AbstractFileFilter(fileType){
                private final String name;
                final /* synthetic */ FileType $fileType;
                {
                    this.$fileType = $fileType;
                    this.name = "Undefined";
                }

                public String getName() {
                    return this.name;
                }

                public String[] getExtensions() {
                    return this.$fileType.getExtensions();
                }

                public String getDefaultExtension() {
                    return this.$fileType.getExtensions()[0];
                }
            };
            if (first == null) {
                first = filter2;
            }
            JFileChooser jFileChooser2 = this.fileChooser;
            Intrinsics.checkNotNull((Object)jFileChooser2);
            jFileChooser2.addChoosableFileFilter(filter2);
            this.map.put(filter2, fileType);
            this.reverseMap.put(fileType, filter2);
        }
        if (first != null) {
            JFileChooser jFileChooser3 = this.fileChooser;
            Intrinsics.checkNotNull((Object)jFileChooser3);
            jFileChooser3.setFileFilter(first);
        }
    }

    @Nullable
    public final CPFile showOpenDialog(@Nullable CPWindow window) {
        CPFile cPFile;
        JFileChooser jFileChooser = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser);
        CPWindow cPWindow = window;
        Intrinsics.checkNotNull((Object)cPWindow);
        int accept = jFileChooser.showOpenDialog(cPWindow.getNativeWindow());
        if (accept == 0) {
            JFileChooser jFileChooser2 = this.fileChooser;
            Intrinsics.checkNotNull((Object)jFileChooser2);
            File file = jFileChooser2.getSelectedFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getSelectedFile(...)");
            cPFile = new CPFile(file);
        } else {
            cPFile = null;
        }
        return cPFile;
    }

    @Nullable
    public final CPFile showSaveDialog(@Nullable CPWindow window) {
        CPFile cPFile;
        JFileChooser jFileChooser = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser);
        CPWindow cPWindow = window;
        Intrinsics.checkNotNull((Object)cPWindow);
        int accept = jFileChooser.showSaveDialog(cPWindow.getNativeWindow());
        if (accept == 0) {
            JFileChooser jFileChooser2 = this.fileChooser;
            Intrinsics.checkNotNull((Object)jFileChooser2);
            File file = jFileChooser2.getSelectedFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getSelectedFile(...)");
            cPFile = new CPFile(file);
        } else {
            cPFile = null;
        }
        return cPFile;
    }

    @Nullable
    public final FileType getSelectedFileType() {
        JFileChooser jFileChooser = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser);
        return this.map.get(jFileChooser.getFileFilter());
    }

    public final void setSelectedFileType(@Nullable FileType value) {
        JFileChooser jFileChooser = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser);
        jFileChooser.setFileFilter(this.reverseMap.get(value));
    }

    public final void setCurrentDirectory(@Nullable CPFile currentDirectory) {
        JFileChooser jFileChooser = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser);
        CPFile cPFile = currentDirectory;
        Intrinsics.checkNotNull((Object)cPFile);
        jFileChooser.setCurrentDirectory(cPFile.getNativeFile());
    }

    public final void setSelectedFile(@Nullable CPFile selectedFile) {
        JFileChooser jFileChooser = this.fileChooser;
        Intrinsics.checkNotNull((Object)jFileChooser);
        CPFile cPFile = selectedFile;
        Intrinsics.checkNotNull((Object)cPFile);
        jFileChooser.setSelectedFile(cPFile.getNativeFile());
    }
}

