/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document

import com.macrofocus.application.ApplicationModel
import com.macrofocus.application.properties.DocumentBasedApplicationProperties
import com.macrofocus.common.command.Command
import com.macrofocus.common.command.Future
import com.macrofocus.common.command.FutureCommand
import com.macrofocus.common.command.UICommand
import com.macrofocus.common.file.CPFile
import com.macrofocus.common.file.FileType
import org.mkui.window.CPWindow

/**
 * Created by luc on 02/12/15.
 */
interface DocumentBasedApplication<D : Document, V : View<D>> {
    enum class Mode {
        Normal, Expert
    }

    val mode: Mode?
        get() = Mode.Normal

    val applicationState: DocumentBasedApplicationState<D, V>?

    /* Properties of the application that never change */
    val applicationModel: ApplicationModel
    val openFileTypes: Array<FileType>
    val saveFileTypes: Array<FileType>?
        get() = null

    val name: String?
        get() = applicationModel.name

    /* Lifecycle */
    fun init()

    fun stop()
    fun newDocument(): D?

    fun openLocalDocument(file: CPFile?, content: String?, window: CPWindow?): D?

    fun openRemoteDocument(name: String?, url: String?, content: String?): D?
    fun getReloadCommand(view: V?): UICommand?
    fun saveView(view: V?)
    fun saveView(view: V?, file: CPFile?, fileType: FileType?)
    fun <C : Command?, R> runAsyncBackground(
        command: C?,
        callback: Callback<C?, R?>?
    )

    fun <C : FutureCommand<R?>?, R> runAsyncFuture(command: FutureCommand<R?>?): Future<R?>?
    fun closeView(view: V?)
    fun showDocument(window: CPWindow?, document: D?)
    fun openAndShowDocument(
        window: CPWindow?,
        documentOpener: DocumentOpener<D>,
        file: CPFile?
    )

    fun createLocalProperties(): DocumentBasedApplicationProperties?
    fun createView(window: CPWindow?, document: D?): V?
    fun createWindow(): CPWindow
    fun setup(window: CPWindow?, view: V?)
    fun runAsyncUIThread(command: Command)
    fun runAsyncBackground(command: Command)
    interface Callback<T, R> {
        fun execute(arg: T?): R?
    }
}