/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.application.document

/**
 * The state of a document
 */
class DocumentState {
    var name: String?
        private set
    var url: String?
        private set

    constructor(url: String?) {
        this.url = url
        var name = url
        if (name != null) {
            val pathparts: Array<String?> = name.split("\\/").toTypedArray()
            name = pathparts[pathparts.size - 1]
            name = name!!.replace("%20".toRegex(), " ")
        }
        this.name = name
    }

    constructor(name: String?, url: String?) {
        this.name = name
        this.url = url
    }

}