/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.collection

object Arrays {
    fun toString(a: Array<Any?>?): String? {
        if (a == null) return "null"
        val iMax = a.size - 1
        if (iMax == -1) return "[]"
        val b: StringBuilder = StringBuilder()
        b.append('[')
        var i = 0
        while (true) {
            b.append(a[i].toString())
            if (i == iMax) return b.append(']').toString()
            b.append(", ")
            i++
        }
    }
}

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun <T> arraycopy(src: Array<T>, srcPos: Int, dst: Array<T>, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun arraycopy(src: BooleanArray, srcPos: Int, dst: BooleanArray, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun arraycopy(src: LongArray, srcPos: Int, dst: LongArray, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun arraycopy(src: ByteArray, srcPos: Int, dst: ByteArray, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun arraycopy(src: ShortArray, srcPos: Int, dst: ShortArray, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun arraycopy(src: CharArray, srcPos: Int, dst: CharArray, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun arraycopy(src: IntArray, srcPos: Int, dst: IntArray, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun arraycopy(src: FloatArray, srcPos: Int, dst: FloatArray, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }

/** Copies [size] elements of [src] starting at [srcPos] into [dst] at [dstPos]  */
inline fun arraycopy(src: DoubleArray, srcPos: Int, dst: DoubleArray, dstPos: Int, size: Int): Unit =
    run { src.copyInto(dst, dstPos, srcPos, srcPos + size) }