package com.macrofocus.common.collection

class UniversalComparator : Comparator<Any?> {
    override fun compare(o1: Any?, o2: Any?): Int {
        return if (o1 != null && o2 != null) {
            if (o2::class == o1::class) {
                if (o1 is Comparable<*> && o2 is Comparable<*>) {
                    o1.compareTo(o2 as Nothing)
                } else {
                    o1.toString().compareTo(o2.toString())
                }
            } else if (o2 is Number && o1 is Number) {
                val number1 = o1
                val number2 = o2
                if (number1.toDouble() < number2.toDouble()) return -1
                if (number1.toDouble() > number2.toDouble()) 1 else 0
            } else {
                o1.toString().compareTo(o2.toString())
            }
        } else {
            if (o1 != null) {
                1
            } else if (o2 != null) {
                -1
            } else {
                0
            }
        }
    }

    fun compare(number1: Number, number2: Number): Int {
        if (number2::class == number1::class) {
            // both numbers are instances of the same type!
            if (number1 is Comparable<*>) {
                // and they implement the Comparable interface
                return (number1 as Comparable<*>).compareTo(number2 as Nothing)
            }
        }
        // for all different Number types, let's check there double values
        if (number1.toDouble() < number2.toDouble()) return -1
        return if (number1.toDouble() > number2.toDouble()) 1 else 0
    }
}
