package com.macrofocus.common.concurrent

import com.macrofocus.common.command.Future

expect class ExecutorService {
    /**
     * Submits a value-returning task for execution and returns a
     * Future representing the pending results of the task. The
     * Future's `get` method will return the task's result upon
     * successful completion.
     *
     *
     *
     * If you would like to immediately block waiting
     * for a task, you can use constructions of the form
     * `result = exec.submit(aCallable).get();`
     *
     *
     * Note: The [Executors] class includes a set of methods
     * that can convert some other common closure-like objects,
     * for example, [java.security.PrivilegedAction] to
     * [Callable] form so they can be submitted.
     *
     * @param task the task to submit
     * @param <T> the type of the task's result
     * @return a Future representing pending completion of the task
     * @throws RejectedExecutionException if the task cannot be
     * scheduled for execution
     * @throws NullPointerException if the task is null
    </T> */
    fun <T> submit(task: Callable<T>?): Future<T>?
}