package com.macrofocus.common.format

import com.macrofocus.common.date.CPTimeZone
import com.macrofocus.common.locale.CPLocale

/**
 * Created by luc on 14/12/15.
 */
expect class FormatFactory {
    fun createOrdinalFormat(): CPFormat<Any?>
    fun createMilionFormat(decimalFormat: CPFormat<Any?>): CPFormat<Any?>
    fun createDecimalFormat(): CPFormat<Any?>
    fun createDecimalFormat(fractionDigits: Int): CPFormat<Any?>
    fun createDecimalFormat(
        fractionDigits: Int,
        pre: String?,
        post: String?,
        rounding: Double,
        factor: Double
    ): CPFormat<Any?>

    fun createIntegerFormat(): CPFormat<Any?>
    fun createIntegerFormat(pre: String?, post: String?, rounding: Double): CPFormat<Any?>
    fun createPercentDecimalFormat(fractionDigits: Int): CPFormat<Any?>
    fun createPercentDecimalFormat(fractionDigits: Int, rounding: Double): CPFormat<Any?>
    fun createStarFormat(): CPFormat<Any?>
    fun createStarFormat(na: String?): CPFormat<Any?>
    fun createBooleanFormat(): CPFormat<Any?>
    fun createDateFormat(): CPFormat<Any?>
    fun createDateTimeFormat(): CPFormat<Any?>
    fun createDateOrDateTimeFormat(): CPFormat<Any?>
    fun createNumberFormat(pattern: String?): CPFormat<Any?>
    fun createDateFormat(pattern: String?): CPFormat<Any?>
    fun createDateFormat(pattern: String?, locale: CPLocale?): CPFormat<Any?>
    fun createDateFormat(pattern: String?, locale: CPLocale?, zone: CPTimeZone?): CPFormat<Any?>
    fun createFormat(pre: String?, post: String?): CPFormat<Any?>

    companion object {
        val instance : FormatFactory
    }

}
