/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.properties

/**
 * Defines the requirements for a collection of properties that can change.
 */
interface MutableProperties<K> : Properties<K> {
    fun <T> createProperty(name: K, value: T): MutableProperty<T>
    fun <T> addProperty(name: K, property: MutableProperty<T>): MutableProperty<T>
    fun <T> replaceProperty(name: K, property: MutableProperty<T>): MutableProperty<T>
    fun setValue(name: K, value: Any?)
    override fun getProperty(name: K): MutableProperty<Any?>
}