/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

/**
 * This interface constrains the selection to be restricted to a single element.
 *
 * @param <E> the type of elements that can be selected
</E> */
interface SingleSelection<E> : Selection<E> {
    val selected: E?
    fun addSingleSelectionListener(listener: SingleSelectionListener<E>)
    fun addWeakSingleSelectionListener(listener: SingleSelectionListener<E>)
    fun removeSingleSelectionListener(listener: SingleSelectionListener<E>)
}