package com.macrofocus.common.units

open class ApparentPower(name: String, symbol: String, ratio: Double) : Unit(name, symbol, ratio) {
    companion object Factory {
        val VoltAmpere = ApparentPower("Volt-ampere", "V⋅A", 1.0)
        val MegavoltAmpere = ApparentPower("Megavolt-ampere", "MV⋅A", 1000000.0)
    }
}

val Number.VoltAmpere: Quantity<ApparentPower> get() = Quantity(this.toDouble(), ApparentPower.VoltAmpere)
val Number.MegavoltAmpere: Quantity<ApparentPower> get() = Quantity(this.toDouble(), ApparentPower.MegavoltAmpere)

