package com.macrofocus.common.units

open class Power(name: String, symbol: String, ratio: Double) : Unit(name, symbol, ratio) {
    companion object Factory {
        val Picowatt = Power("Picowatt", "pW", 0.0000001)
        val Nanowatt = Power("Nanowatt", "nW", 0.0000000001)
        val Microwatt = Power("Microwatt", "µW", 0.0000001)
        val Milliwatt = Power("Kilowatt", "mW", 0.0001)
        val Watt = Power("Kilowatt", "W", 1.0)
        val Kilowatt = Power("Kilowatt", "KW", 1000.0)
        val Megawatt = Power("Megawatt", "MW", 1000000.0)
        val Gigawatt = Power("Gigawatt", "GW", 1000000000.0)
        val Terawatt = Power("Terawatt", "TW", 1000000000000.0)
        val Petawatt = Power("Terawatt", "PW", 1000000000000000.0)
        val Horsepower = Power("Metric horsepower", "hp(M)", 735.49875)
    }
}

val Number.Picowatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Picowatt)
val Number.Nanowatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Nanowatt)
val Number.Microwatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Microwatt)
val Number.Milliwatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Milliwatt)
val Number.Watt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Watt)
val Number.Kilowatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Kilowatt)
val Number.Megawatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Megawatt)
val Number.Gigawatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Gigawatt)
val Number.Terawatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Terawatt)
val Number.Petawatt: Quantity<Power> get() = Quantity(this.toDouble(), Power.Petawatt)
val Number.Horsepower: Quantity<Power> get() = Quantity(this.toDouble(), Power.Horsepower)


