/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.collection

object Collections {
    fun <T> addAll(c: MutableCollection<in T?>?, vararg elements: T?): Boolean {
        var result = false
        for (element in elements) result = result or c!!.add(element)
        return result
    }

    // ToDo: JSweet doesn't support Collections.removeIf()
//    fun <T> removeIf(c: MutableCollection<T?>?, filter: Predicate<T?>?): Boolean {
//        var removed = false
//        val each = c!!.iterator()
//        while (each.hasNext()) {
//            val next = each.next()
//            if (filter.test(next)) {
//                each.remove()
//                removed = true
//            }
//        }
//        return removed
//    }
}