package com.macrofocus.common.collection

typealias TIntArrayList = ArrayList<Int>
typealias TIntList = MutableList<Int>

typealias TIntHashSet = HashSet<Int>
typealias TIntSet= MutableSet<Int>

typealias TIntIntHashMap = HashMap<Int,Int>
typealias TIntIntMap = MutableMap<Int,Int>

typealias TObjectDoubleHashMap<K> =  HashMap<K,Double>
typealias TObjectDoubleMap<K> = MutableMap<K,Double>

/**
 * Adjusts the primitive value mapped to the key if the key is present in the map.
 * Otherwise, the <tt>initial_value</tt> is put in the map.
 *
 * @param key the key of the value to increment
 * @param adjust_amount the amount to adjust the value by
 * @param put_amount the value put into the map if the key is not initial present
 *
 * @return the value present in the map after the adjustment or put operation
 */
inline fun <K> TObjectDoubleMap<K>.adjustOrPutValue(key: K, adjust_amount: Double, put_amount: Double): Double {
    val value = getOrPut(key, { put_amount - adjust_amount }) + adjust_amount
    put(key, value)
    return value
}

/**
 * Adjusts the primitive value mapped to key.
 *
 * @param key the key of the value to increment
 * @param amount the amount to adjust the value by.
 * @return true if a mapping was found and modified.
 */
inline fun <K> TObjectDoubleMap<K>.adjustValue(key: K, amount: Double): Boolean {
    val value = get(key)
    if(value != null) {
        put(key, value + amount)
        return true
    } else {
        return false
    }
}
