/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.filter

/**
 * The listener interface for receiving "interesting" events about filtering.
 *
 * @param <E> the type of elements that can be filtered.
</E> */
interface FilterListener<E> {
    /**
     * Called whenever the value of the filter changes.
     *
     * @param event the event that characterizes the change.
     */
    fun filterChanged(event: FilterEvent<E>)
}