/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.filter

/**
 * As long as an index hasn't been set (presumably by SubsetDataFrame), then the responsability is deferred to the
 * underlying input filter.
 */
class SimpleIndexFilter<E> : AbstractMutableIndexFilter<E>() {
    override val inputFilter: MutableFilter<E>

    // Filter
    override val isActive: Boolean
        get() = if (index == null) {
            inputFilter.isActive
        } else {
            super.isActive
        }
    override var filteredCount: Int
        get() = if (index == null) {
            inputFilter.filteredCount
        } else {
            super.filteredCount
        }
        set(filteredCount) {
            super.filteredCount = filteredCount
        }

    override fun isFiltered(element: E): Boolean {
        return if (index == null) {
            inputFilter.isActive
        } else {
            !index!!.contains(element)
        }
    }

    override var isEnabled: Boolean
        get() = if (index == null) {
            inputFilter.isEnabled
        } else {
            super.isEnabled
        }
        set(isEnabled) {
            super.isEnabled = isEnabled
        }

    override fun isFilteredBy(element: E, locksmith: Any): Boolean {
        return inputFilter.isFilteredBy(element, locksmith)
    }

    // MutableFilter
    override fun setFiltered(element: E, filtered: Boolean, locksmith: Any) {
        inputFilter.setFiltered(element, filtered, locksmith)
    }

    override fun setFilteredIterable(elements: Iterable<E>, filtered: Boolean, locksmith: Any) {
        inputFilter.setFilteredIterable(elements, filtered, locksmith)
    }

    override fun setFilteredState(filtered: Iterable<E>, unfiltered: Iterable<E>, locksmith: Any) {
        inputFilter.setFilteredState(filtered, unfiltered, locksmith)
    }

    override fun clearFilter() {
        inputFilter.clearFilter()
    }

    override fun clearFilterBy(locksmith: Any) {
        inputFilter.clearFilterBy(locksmith)
    }

    init {
        inputFilter = SimpleFilter()
    }
}