package com.macrofocus.common.units

/**
 * Apparent or complex power
 */
open class ApparentPower(name: String, symbol: String, ratio: Double) : Unit(name, symbol, ratio) {
    companion object Factory {
        val VoltAmpere = ApparentPower("Volt-ampere", "VA", 1.0)
        val KilovoltAmpere = ApparentPower("Kilovolt-ampere", "kVA", 1000.0)
        val MegavoltAmpere = ApparentPower("Megavolt-ampere", "MVA", 1000000.0)
    }
}

val Number.VoltAmpere: Quantity<ApparentPower> get() = Quantity(this.toDouble(), ApparentPower.VoltAmpere)
val Number.KilovoltAmpere: Quantity<ApparentPower> get() = Quantity(this.toDouble(), ApparentPower.KilovoltAmpere)
val Number.MegavoltAmpere: Quantity<ApparentPower> get() = Quantity(this.toDouble(), ApparentPower.MegavoltAmpere)

