package com.macrofocus.common.units

open class Distance(name: String, symbol: String, ratio: Double): Unit(name, symbol, ratio) {
    companion object {
        val Mile = Distance("Mile","mi", 1.60934 * 1000.0)
        val Kilometer = Distance("Kilometer","km", 1000.0)
        val Meter = Distance("Meter", "m", 1.0)
        val Centimeter = Distance("Centimeter", "cm", 0.1)
        val Millimeter = Distance("Millimeter", "mm", 0.01)
    }
}