package com.macrofocus.common.units

import com.macrofocus.common.units.Angle.Factory.Radian
import kotlin.math.cos
import kotlin.math.pow
import kotlin.math.sin
import kotlin.math.sqrt

//fun Quantity<Voltage>.intoPower(current: Quantity<Current>, unit: Power = Power.Watt): Quantity<Power> {
//    return power(this, current, unit)
//}

//fun Quantity<Current>.intoPower(voltage: Quantity<Voltage>, unit: Power = Power.Watt): Quantity<Power> {
//    return power(voltage, this, unit)
//}

fun power(voltage: Quantity<Voltage>, current: Quantity<Current>, unit: Power = Power.Watt): Quantity<Power> {
    return (voltage.into(Voltage.Volt).amount * current.into(Current.Ampere).amount).into(unit)
}

fun apparentPower1(activePower: Quantity<Power>, phaseAngle: Quantity<Angle>, unit: ApparentPower = ApparentPower.VoltAmpere): Quantity<ApparentPower> {
    return (activePower.amount / cos(phaseAngle.into(Radian).amount)).into(unit)
}

fun apparentPower2(activePower: Quantity<Power>, reactivePower: Quantity<ReactivePower>, unit: ApparentPower = ApparentPower.VoltAmpere): Quantity<ApparentPower> {
    return sqrt(activePower.amount.pow(2) + reactivePower.amount.pow(2)).into(unit)
}

fun activePower(apparentPower: Quantity<ApparentPower>, phaseAngle: Quantity<Angle>, unit: Power = Power.Watt): Quantity<Power> {
    return (apparentPower.amount * cos(phaseAngle.into(Radian).amount)).into(unit)
}

fun reactivePower(activePower: Quantity<ApparentPower>, phaseAngle: Quantity<Angle>, unit: ReactivePower = ReactivePower.VoltAmpereReactive): Quantity<ReactivePower> {
    return (activePower.amount * sin(phaseAngle.into(Radian).amount)).into(unit)
}

fun powerFactor(phaseAngle: Quantity<Angle>): Double {
    return cos(phaseAngle.into(Radian).amount)
}