/*
 * Copyright (c) 2011 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.hierarchy

internal class BreadthFirstIterator<T>(private val hierarchy: Hierarchy<T>, rootNode: T) : MutableIterator<T> {
    protected val queue: Queue<Iterator<T>>
    override fun hasNext(): Boolean {
        return !queue.isEmpty && queue.firstObject().hasNext()
    }

    override fun next(): T {
        val enumer: Iterator<T> = queue.firstObject()
        val node = enumer.next()
        val children = hierarchy.getChildren(node)!!.iterator()
        if (!enumer.hasNext()) {
            queue.dequeue()
        }
        if (children.hasNext()) {
            queue.enqueue(children)
        }
        return node
    }

    override fun remove() {
        throw UnsupportedOperationException()
    }

    /**
     * A simple queue with a linked list data structure.
     */
    internal inner class Queue<O> {
        var head // null if empty
                : QNode<O>? = null
        var tail: QNode<O>? = null
        fun enqueue(anObject: O) {
            if (head == null) {
                tail = QNode<O>(anObject, null)
                head = tail
            } else {
                tail!!.next = QNode<O>(anObject, null)
                tail = tail!!.next
            }
        }

        fun dequeue(): O {
            if (head == null) {
                throw NoSuchElementException("No more elements")
            }
            val retval: O = head!!.`object`
            val oldHead: QNode<O> = head!!
            head = head!!.next
            if (head == null) {
                tail = null
            } else {
                oldHead.next = null
            }
            return retval
        }

        fun firstObject(): O {
            if (head == null) {
                throw NoSuchElementException("No more elements")
            }
            return head!!.`object`
        }

        val isEmpty: Boolean
            get() = head == null
    }

    internal inner class QNode<O>(val `object`: O, next: QNode<O>?) {
        var next // null if end
                : QNode<O>?

        init {
            this.next = next
        }
    }

    init {
        val v: MutableList<T> = ArrayList<T>(1)
        v.add(rootNode)
        queue = Queue<Iterator<T>>()
        queue.enqueue(v.iterator())
    }
}