/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.filter

/**
 * Defines the requirements for a filter that can change.
 */
interface MutableFilter<E> : Filter<E> {
    override var isEnabled: Boolean
    fun setFiltered(element: E, filtered: Boolean, locksmith: Any)
    fun setFilteredIterable(elements: Iterable<E>, filtered: Boolean, locksmith: Any)
    fun setFilteredState(filtered: Iterable<E>, unfiltered: Iterable<E>, locksmith: Any)
    fun clearFilter()
    fun clearFilterBy(locksmith: Any)
//    fun setEnabled(enabled: Boolean)
}