package com.macrofocus.common.scale

import com.macrofocus.common.format.CPFormat
import com.macrofocus.common.interval.Interval
import com.macrofocus.common.interval.OpenInterval

/**
 * A transformation encapsulates a transformation and its inverse, as well
 * as the information needed to create pleasing breaks and labels.
 */
interface Transform {
    val shortName: String

    val transform: (Double) -> Double

    val inverse: ((Double) -> Double)?

    val dtransform: ((Double) -> Double)?

    val dinverse: ((Double) -> Double)?

    val minorBreaks: Any?
        get() = null

    val format: CPFormat<Double?>?
        get() = null

    val domain: Interval?
        get() = OpenInterval(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY)
}
