/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

/**
 * Default implementation of a SelectionEvent for single selection.
 */
class SingleSelectionEvent<E>(
    model: SingleSelection<E>,
    previousActive: Boolean,
    currentActive: Boolean,
    previousSelection: E?,
    currentSelection: E?
) : AbstractSelectionEvent<E>() {
    override val model: SingleSelection<E>
    private val previousActive: Boolean
    private val currentActive: Boolean
    val previousSelection: E?
    val currentSelection: E?
    private var changes: MutableSet<E>? = null

    override fun isAffected(element: E): Boolean {
        return element == previousSelection || element == currentSelection
    }

    override val affected: Iterable<E>
        get() {
            if (changes == null) {
                changes = HashSet()
                if (previousActive) {
                    changes!!.add(previousSelection!!)
                }
                if (currentActive) {
                    changes!!.add(currentSelection!!)
                }
            }
            return changes!!
        }

//    override fun toString(): String {
//        val sb = StringBuffer("SingleSelectionEvent{")
//        sb.append("previousSelection=").append(previousSelection)
//        sb.append(", currentSelection=").append(currentSelection)
//        sb.append('}')
//        return sb.toString()
//    }

    init {
        this.model = model
        this.previousActive = previousActive
        this.currentActive = currentActive
        this.previousSelection = previousSelection
        this.currentSelection = currentSelection
    }
}