/*
 * Copyright (c) 2011 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.hierarchy

import com.macrofocus.common.collection.Stack
import com.macrofocus.common.collection.peek
import com.macrofocus.common.collection.pop
import com.macrofocus.common.collection.push


internal class PreorderEnumeration<T>(private val hierarchy: Hierarchy<T>, protected val root: T) : MutableIterator<T> {
    private val stack: Stack<Iterator<T>>
    override fun hasNext(): Boolean {
        return !stack.isEmpty() &&
                stack.peek()!!.hasNext()
    }

    override fun next(): T {
        val enumer: Iterator<T> = stack.peek()!!
        val node = enumer.next()
        val children = hierarchy.getChildren(node)!!.iterator()
        if (!enumer.hasNext()) {
            stack.pop()
        }
        if (children.hasNext()) {
            stack.push(children)
        }
        return node
    }

    override fun remove() {
        throw UnsupportedOperationException()
    }

    init {
        val v: MutableList<T> = ArrayList<T>(1)
        v.add(root)
        stack = ArrayList<Iterator<T>>()
        stack.push(v.iterator())
    }
}