package com.macrofocus.common.collection

var WeakHashMap_Ids:Int = 0
actual class WeakHashMap<K, V> : MutableMap<K, V>{
    fun genId() = "weakmap-${WeakHashMap_Ids++}"
    var id = genId()

    actual override val size: Int
        get() = Int.MAX_VALUE

    actual override fun containsKey(key: K): Boolean {
        return (key.asDynamic()[id] as? Any).takeIf { it != undefined }  != null
    }

    actual override fun containsValue(value: V): Boolean = throw UnsupportedOperationException()

    actual override operator fun get(key: K): V? {
        val existing = (key.asDynamic()[id] as? Any).takeIf { it != undefined } as? V
        return existing
    }

    actual override fun isEmpty(): Boolean = false

    actual override val entries: MutableSet<MutableMap.MutableEntry<K, V>> = mutableSetOf()
    actual override val keys: MutableSet<K> = mutableSetOf()
    actual override val values: MutableCollection<V> = mutableSetOf()

    actual override fun clear() {
        id = genId()
    }

    actual override fun put(key: K, value: V): V? {
        val existing = (key.asDynamic()[id] as? Any).takeIf { it != undefined } as? V
        key.asDynamic()[id] = value
        return existing
    }

    actual override fun putAll(from: Map<out K, V>) {
        for((entry, value) in from){
            put(entry, value)
        }
    }

    actual override fun remove(key: K): V? {
        val existing = (key.asDynamic()[id] as? Any).takeIf { it != undefined } as? V
        key.asDynamic()[id] = null
        return existing
    }

}