package com.macrofocus.common.concurrent

import com.macrofocus.common.command.Future

actual class FutureTask<V> actual constructor(private val callable: Callable<V>) : Future<V>,Runnable {
    actual override val isDone: Boolean
        get() = _isDone
    private var _isDone: Boolean = false
    actual override val isCancelled: Boolean
        get() = false

    actual override fun get(): V? {
        val reply = callable.call()
        _isDone = true
        return reply
    }

    actual override fun cancel(mayInterruptIfRunning: Boolean): Boolean {
        return false
    }

    actual override fun run() {
        get()
    }
}