package com.macrofocus.common.crossplatform

import com.macrofocus.common.timer.AbstractCPTimer

class GWTTimer(val name: String?, private val delay: Int, private val postponing: Boolean) : AbstractCPTimer() {
    private val timer: Timer

    //    private val command: MyScheduledCommand = MyScheduledCommand()
    override fun restart() {
        if (postponing || !timer.isRunning) {
            timer.schedule(delay)
        }
    }

//    private inner class MyScheduledCommand : Scheduler.ScheduledCommand {
//        fun execute() {
//            for (listener in listeners) {
//                listener.timerTriggered()
//            }
//        }
//    }

    init {
        timer = object : Timer() {
            override fun run() {
//                Scheduler.get().scheduleDeferred(command)
                for (listener in listeners) {
                    listener.timerTriggered()
                }
            }
        }
    }
}
