package com.macrofocus.common.json

/**
 * Factory interface for parsing and creating JSON objects.
 */
actual object JsonFactory {
    actual fun create(string: String): JsonString {
        return string.unsafeCast<JsonString>()
//        return JsonString.create(string)
    }

    actual fun create(number: Double): JsonNumber {
        return number.unsafeCast<JsonNumber>()
//        return JsonNumber.create(number)
    }

    actual fun create(bool: Boolean): JsonBoolean {
        return bool.unsafeCast<JsonBoolean>()
//        return JsonBoolean.create(bool)
    }

    actual fun createArray(): JsonArray {
        val res: dynamic = js("([])")
        return res
//        return string.unsafeCast<JsonString>()
//        return JsonArray.create()
    }

    actual fun createNull(): JsonNull {
        return js("null;")
//        return null as JsonNull
//        return JsonNull.create()
    }

    actual fun createObject(): JsonObject {
        val res: dynamic = js("({})")
        return res
//        return JsonObject.create()
    }

    actual fun <T : JsonValue?> parse(jsonString: String): T {
        return JSON.parse<T>(jsonString)
    }
}