package com.macrofocus.common.collection

open class SimpleImmutableEntry<K, V>(override val key: K, value: V) : Map.Entry<K, V> {
    constructor(entry: Map.Entry<K, V>) : this(entry.key, entry.value)

    private var _value = value

    override val value: V get() = _value

    override fun hashCode(): Int = entryHashCode(this)
    override fun toString(): String = entryToString(this)
    override fun equals(other: Any?): Boolean = entryEquals(this, other)

    internal companion object {
        internal fun entryHashCode(e: Map.Entry<*, *>): Int = with(e) { (key?.hashCode() ?: 0) xor (value?.hashCode() ?: 0) }
        internal fun entryToString(e: Map.Entry<*, *>): String = with(e) { "$key=$value" }
        internal fun entryEquals(e: Map.Entry<*, *>, other: Any?): Boolean {
            if (other !is Map.Entry<*, *>) return false
            return e.key == other.key && e.value == other.value
        }
    }
}