/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.command

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.Property
import com.macrofocus.common.properties.SimpleProperty

abstract class AbstractUICommand(
    titleProperty: MutableProperty<String?>?,
    enabledProperty: MutableProperty<Boolean?>? = SimpleProperty(true),
    keystrokeProperty: Property<String?>? = null,
    mnemonicProperty: Property<String?>? = null,
    iconProperty: Property<Any?>? = null
) : UICommand {
    private val titleProperty: MutableProperty<String?>?
    private val enabledProperty: MutableProperty<Boolean?>?
    private val keystrokeProperty: Property<String?>?
    private val mnemonicProperty: Property<String?>?
    private val iconProperty: Property<Any?>?

    constructor(title: String?) : this(SimpleProperty(title)) {}
//    constructor(title: String?, keystroke: String?) : this(
//        SimpleProperty(title),
//        SimpleProperty(true),
//        SimpleProperty(keystroke),
//        SimpleProperty(null),
//        SimpleProperty(null)
//    ) {
//    }

//    constructor(titleProperty: MutableProperty<String?>?) : this(
//        titleProperty,
//        SimpleProperty(true)
//    ) {
//    }
//
//    constructor(titleProperty: MutableProperty<String?>?, keystrokeProperty: Property<String?>?) : this(
//        titleProperty,
//        SimpleProperty(true),
//        keystrokeProperty,
//        SimpleProperty(null),
//        SimpleProperty(null)
//    ) {
//    }
//
//    constructor(titleProperty: MutableProperty<String?>?, keystroke: String?) : this(
//        titleProperty,
//        SimpleProperty(true),
//        SimpleProperty(keystroke),
//        SimpleProperty(null),
//        SimpleProperty(null)
//    ) {
//    }
//
//    constructor(titleProperty: MutableProperty<String?>?, enabledProperty: MutableProperty<Boolean?>?) : this(
//        titleProperty,
//        enabledProperty,
//        SimpleProperty(null),
//        SimpleProperty(null),
//        SimpleProperty(null)
//    ) {
//    }

    override fun titleProperty(): MutableProperty<String?>? {
        return titleProperty
    }

    override fun enabledProperty(): MutableProperty<Boolean?>? {
        return enabledProperty
    }

    override fun keystrokeProperty(): Property<String?>? {
        return keystrokeProperty
    }

    override fun mnemonicProperty(): Property<String?>? {
        return mnemonicProperty
    }

    override fun iconProperty(): Property<Any?>? {
        return iconProperty
    }

    override fun toString(): String {
        return titleProperty!!.value!!
    }

    init {
        this.titleProperty = titleProperty
        this.enabledProperty = enabledProperty
        this.keystrokeProperty = keystrokeProperty
        this.mnemonicProperty = mnemonicProperty
        this.iconProperty = iconProperty
    }
}