/*
 * Copyright (c) 2018 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.command

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.Property

interface UICommand : Command {
    fun titleProperty(): Property<String?>?
    fun enabledProperty(): MutableProperty<Boolean?>?
    fun keystrokeProperty(): Property<String?>?
    fun mnemonicProperty(): Property<String?>?
    fun iconProperty(): Property<Any?>?

    override fun execute() {
        execute(null)
    }

    fun execute(source: Any? = null)
}