package com.macrofocus.common.format

import com.macrofocus.common.collection.IdentityHashMap

open class ConvertFormat<T>(values: Array<T>, labels: Array<String>) : AbstractFormat<T>() {
    private val forward: MutableMap<T, String> = IdentityHashMap<T, String>(values.size)
    private val backward: MutableMap<String, T> = HashMap<String, T>(values.size)

    init {
        for (i in values.indices) {
            val value = values[i]
            val label = labels[i]
            forward[value] = label
            backward[label] = value
        }
    }

    override fun formatHtml(value: T, htmlSupported: Boolean): String? {
        return forward[value]
    }

    override fun parse(text: String?): T {
        return backward[text]!!
    }

    override val nativeFormat: Any?
        get() = null
}
