package com.macrofocus.common.interval

import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.scale.Transform

class TransformBoundedInterval(
    private val interval: MutableBoundedInterval,
    private val scale: MutableProperty<Transform>?
) :
    AbstractBoundedInterval(), MutableBoundedInterval {
    private val intervalListener: IntervalListener = object : IntervalListener {
        override fun intervalChanged(event: IntervalEvent) {
            val oldStart = transform(event.oldStart)
            val oldEnd = transform(event.oldEnd)
            val e = IntervalEvent(
                oldStart,
                oldEnd,
                oldEnd - oldStart
            )
            val newStart = transform(event.newStart)
            val newEnd = transform(event.newEnd)
            e.setNewValues(newStart, newEnd, newEnd - newStart)

            notifyIntervalChanged(e)
        }
    }

    private val boundedIntervalListener: BoundedIntervalListener = object : BoundedIntervalListener {
        override fun boundedIntervalChanged(event: BoundedIntervalEvent) {
            notifyBoundedIntervalChanged(event)
        }
    }

    private fun transform(value: Double): Double {
        return scale?.value?.transform?.invoke(value) ?: value
    }

    private fun inverse(value: Double): Double {
        return if (scale != null) {
            scale.value.inverse!!.invoke(value)
        } else {
            value
        }
    }

    init {
        interval.addWeakIntervalListener(intervalListener)
    }


    override fun setValue(value: Double, extent: Double) {
        val start = inverse(value)
        interval.setValue(start, inverse(value + extent) - start)

        //            assert (getMaximumExtent() < getMinimumExtent() && getExtent() <= getMaximumExtent()) ||
//                    getExtent() >= getMinimumExtent(): value + ": " + extent + ", " + this;
    }

    override val startProperty: MutableProperty<Double>
        get() {
            throw UnsupportedOperationException()
            //        return interval.getStartProperty();
        }

    override val endProperty: MutableProperty<Double>
        get() {
            throw UnsupportedOperationException()
            //        return interval.getEndProperty();
        }

    override var start: Double
        get() = transform(interval.start)
        set(value) {
            interval.start = inverse(value)

//            assert(extent >= minimumExtent) { value.toString() + ": " + extent + " " + minimumExtent }
        }

    override var end: Double
        get() = transform(interval.end)
        set(value) {
            interval.end = inverse(value)

//            assert(extent >= minimumExtent)
        }

    override var extent: Double
        get() = end - start
        set(extent) {
            interval.extent = inverse(transform(interval.start) + extent) - interval.start

//            assert(field >= minimumExtent)
        }

    override fun contains(value: Double): Boolean {
        return interval.contains(inverse(value))
    }

    override fun containsStartEnd(start: Double, end: Double): Boolean {
        return interval.containsStartEnd(inverse(start), inverse(end))
    }

    override fun containsInterval(interval: Interval?): Boolean {
        throw UnsupportedOperationException()
        //        return interval.containsInterval(interval);
    }

    override fun overlaps(start: Double, end: Double): Boolean {
        return interval.overlaps(inverse(start), inverse(end))
    }

    override fun overlapsInterval(interval: Interval?): Boolean {
        throw UnsupportedOperationException()
        //        return interval.overlapsInterval(interval);
    }

    override val isDegenerate: Boolean
        get() =//        return interval.isDegenerate();
            extent == 0.0

    override val isInverted: Boolean
        get() =//        return interval.isInverted();
            end < start

    override val isInvertedScale: Boolean
        get() = minimum > maximum

    override var minimum: Double
        get() = transform(interval.minimum)
        set(minimum) {
            //        if(this.minimum != minimum) {
            //            final BoundedIntervalEvent event = new BoundedIntervalEvent(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
            //
            //            this.minimum = minimum;
            //
            //            //        minimumExtent = 0;
            //            maximumExtent = maximum - this.minimum;
            //
            //            event.setNewValues(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
            //            notifyBoundedIntervalChanged(event);
            //        }
            throw UnsupportedOperationException()
        }

    override var maximum: Double
        get() = transform(interval.maximum)
        set(maximum) {
            //        if(this.maximum != maximum) {
            //            final BoundedIntervalEvent event = new BoundedIntervalEvent(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
            //
            //            this.maximum = maximum;
            //
            //            //        minimumExtent = 0;
            //            maximumExtent = this.maximum - minimum;
            //
            //            event.setNewValues(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
            //            notifyBoundedIntervalChanged(event);
            //        }
            throw UnsupportedOperationException()
        }

    override fun setMinMax(min: Double, max: Double) {
//        if(this.minimum != min || this.maximum != max) {
//            final BoundedIntervalEvent event = new BoundedIntervalEvent(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
//
//            minimum = min;
//            maximum = max;
//
//            //        minimumExtent = 0;
//            maximumExtent = max - min;
//
//            event.setNewValues(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
//            notifyBoundedIntervalChanged(event);
//        }
        throw UnsupportedOperationException()
    }

    override fun setMinMaxExtent(min: Double, max: Double, minExtent: Double, maxExtent: Double) {
//        if(this.minimum != min || this.maximum != max || this.minimumExtent != minExtent || this.maximumExtent != maximumExtent) {
//            final BoundedIntervalEvent event = new BoundedIntervalEvent(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
//
//            minimum = min;
//            maximum = max;
//
//            minimumExtent = minExtent;
//            maximumExtent = maxExtent;
//
//            event.setNewValues(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
//            notifyBoundedIntervalChanged(event);
//        }
        throw UnsupportedOperationException()
    }

    override var minimumExtent: Double
        get() = transform(interval.minimum + interval.minimumExtent) - transform(interval.minimum)
        set(minimumExtent) {
            println("Operation TransformBoundedInterval:setMinimumExtent not supported")
            //        if(this.minimumExtent != minimumExtent) {
            //            final BoundedIntervalEvent event = new BoundedIntervalEvent(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
            //
            //            this.minimumExtent = minimumExtent;
            //
            //            event.setNewValues(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
            //            notifyBoundedIntervalChanged(event);
            //        }
        }

    override var maximumExtent: Double
        get() = transform(interval.minimum + interval.maximumExtent) - transform(interval.minimum)
        set(maximumExtent) {
            //        if(this.maximumExtent != maximumExtent) {
            //            final BoundedIntervalEvent event = new BoundedIntervalEvent(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
            //
            //            this.maximumExtent = maximumExtent;
            //
            //            event.setNewValues(this.minimum, this.maximum, this.minimumExtent, this.maximumExtent);
            //            notifyBoundedIntervalChanged(event);
            //        }
            throw UnsupportedOperationException()
        }

    override fun reset() {
//        setValue(getMinimum(), Math.min(getMinimum() + getMaximumExtent(), getMaximum()) - getMinimum());
        interval.reset()
    }

    override fun toString(): String {
        return "TransformBoundedInterval{" +
                "start=" + interval.start +
                ", getStart()=" + start +
                ", end=" + interval.end +
                ", getEnd()=" + end +
                ", extent=" + interval.extent +
                ", getExtent()=" + extent +
                ", getMinimum()=" + minimum +
                ", getMaxmimum()=" + maximum +
                ", getMinimumExtent()=" + minimumExtent +
                ", getMaximumExtent()=" + maximumExtent +
                ", isDegenerate()=" + isDegenerate +
                ", isInverted()=" + isInverted +
                ", isInvertedScale()=" + isInvertedScale +
                '}'
    }
}
