package com.macrofocus.common.json

/**
 * Represents a Json array.
 */
expect interface JsonArray : JsonValue {
}

/**
 * Return the ith element of the array.
 */
expect operator fun <T : JsonValue?> JsonArray.get(index: Int): T

/**
 * Return the ith element of the array (uncoerced) as a JsonArray. If the type is not an array,
 * this can result in runtime errors.
 */
expect fun JsonArray.getArray(index: Int): JsonArray?

/**
 * Return the ith element of the array (uncoerced) as a boolean. If the type is not a boolean,
 * this can result in runtime errors.
 */
expect fun JsonArray.getBoolean(index: Int): Boolean

/**
 * Return the ith element of the array (uncoerced) as a number. If the type is not a number, this
 * can result in runtime errors.
 */
expect fun JsonArray.getNumber(index: Int): Double

/**
 * Return the ith element of the array (uncoerced) as a JsonObject If the type is not an object,,
 * this can result in runtime errors.
 */
expect fun JsonArray.getObject(index: Int): JsonObject?

/**
 * Return the ith element of the array (uncoerced) as a String. If the type is not a String, this
 * can result in runtime errors.
 */
expect fun JsonArray.getString(index: Int): String?

/**
 * Length of the array.
 */
expect fun JsonArray.length(): Int

/**
 * Remove an element of the array at a particular index.
 */
expect fun JsonArray.remove(index: Int)

/**
 * Set the value at index to be a given value.
 */
expect operator fun JsonArray.set(index: Int, value: JsonValue?)

/**
 * Set the value at index to be a String value.
 */
expect operator fun JsonArray.set(index: Int, string: String)

/**
 * Set the value at index to be a number value.
 */
expect operator fun JsonArray.set(index: Int, number: Double)

/**
 * Set the value at index to be a boolean value.
 */
expect operator fun JsonArray.set(index: Int, bool: Boolean)
