package com.macrofocus.common.math

import com.macrofocus.common.collection.arraycopy
import kotlin.jvm.JvmOverloads
import kotlin.math.exp
import kotlin.math.ln
import kotlin.math.min

/**
 * Created by IntelliJ IDEA.
 * User: luc
 * Date: Feb 22, 2007
 * Time: 6:38:16 AM
 */
object Array {
    fun crossSubArray(source: kotlin.Array<FloatArray?>, index: Int): FloatArray {
        val result = FloatArray(source.size)
        for (i in result.indices) result[i] = source[i]!![index]

        return result
    }

    fun intList(from: Int, to: Int): IntArray {
        val entryCount = kotlin.math.abs(to - from) + 1
        val result = IntArray(entryCount)
        val direction = if (to <= from) -1 else 1
        for (i in 0..<entryCount) result[i] = from + i * direction

        return result
    }

    fun duplicate(roleModel: IntArray): IntArray {
        val result = IntArray(roleModel.size)
        arraycopy(roleModel, 0, result, 0, result.size)
        return result
    }

    fun duplicate(roleModel: FloatArray): FloatArray {
        val result = FloatArray(roleModel.size)
        arraycopy(roleModel, 0, result, 0, result.size)
        return result
    }

    fun duplicate(roleModel: kotlin.Array<FloatArray?>): kotlin.Array<FloatArray?> {
        val result = kotlin.arrayOfNulls<FloatArray>(roleModel.size)
        for (i in roleModel.indices) {
            result[i] = FloatArray(roleModel[i]!!.size)
            arraycopy(roleModel[i]!!, 0, result[i]!!, 0, roleModel[i]!!.size)
        }

        return result
    }

    fun duplicate(roleModel: kotlin.Array<BooleanArray?>): kotlin.Array<BooleanArray?> {
        val result = kotlin.arrayOfNulls<BooleanArray>(roleModel.size)
        for (i in roleModel.indices) {
            result[i] = BooleanArray(roleModel[i]!!.size)
            arraycopy(roleModel[i]!!, 0, result[i]!!, 0, roleModel[i]!!.size)
        }

        return result
    }

    fun abs(data: FloatArray): FloatArray {
        val result = FloatArray(data.size)
        for (i in data.indices) result[i] = kotlin.math.abs(data[i])

        return result
    }

    fun interpolate(from: Float, to: Float, sampleCount: Int): FloatArray {
        if (sampleCount < 1) return FloatArray(0)
        if (sampleCount == 1) return (floatArrayOf(
            (from + to) / 2.0f
        ))
        val result = FloatArray(sampleCount)
        result[0] = from
        val step = (to - from) / (sampleCount - 1).toFloat()
        for (i in 1..<result.size) result[i] = result[i - 1] + step

        return result
    }

    fun extract(values: kotlin.Array<FloatArray?>, indices: IntArray): kotlin.Array<FloatArray?> {
        val result = kotlin.arrayOfNulls<FloatArray>(indices.size)
        for (i in result.indices) result[i] = values[indices[i]]

        return result
    }

    fun extract(values: kotlin.Array<IntArray?>, rowIndices: IntArray, columnIndex: Int): IntArray {
        val result = IntArray(rowIndices.size)
        for (i in result.indices) result[i] = values[rowIndices[i]]!![columnIndex]

        return result
    }

    fun extract(values: kotlin.Array<FloatArray?>, rowIndices: IntArray, columnIndex: Int): FloatArray {
        val result = FloatArray(rowIndices.size)
        for (i in result.indices) result[i] = values[rowIndices[i]]!![columnIndex]

        return result
    }

    fun extract(values: kotlin.Array<IntArray?>, indices: IntArray): kotlin.Array<IntArray?> {
        val result = kotlin.arrayOfNulls<IntArray>(indices.size)
        for (i in result.indices) result[i] = values[indices[i]]

        return result
    }

    fun extract(values: kotlin.Array<BooleanArray?>, indices: IntArray): kotlin.Array<BooleanArray?> {
        val result = kotlin.arrayOfNulls<BooleanArray>(indices.size)
        for (i in result.indices) result[i] = values[indices[i]]

        return result
    }

    fun extract(values: FloatArray, indices: IntArray): FloatArray {
        val result = FloatArray(indices.size)
        for (i in result.indices) result[i] = values[indices[i]]

        return result
    }

    fun extract(values: BooleanArray, indices: IntArray): BooleanArray {
        val result = BooleanArray(indices.size)
        for (i in result.indices) result[i] = values[indices[i]]

        return result
    }

    fun extract(values: kotlin.Array<String?>, indices: IntArray): kotlin.Array<String?> {
        val result = kotlin.arrayOfNulls<String>(indices.size)
        for (i in result.indices) result[i] = values[indices[i]]

        return result
    }

    fun extract(values: DoubleArray, indices: IntArray): DoubleArray {
        val result = DoubleArray(indices.size)
        for (i in result.indices) result[i] = values[indices[i]]

        return result
    }

    fun extractColumn(values: kotlin.Array<IntArray?>, column: Int): IntArray {
        val result = IntArray(values.size)
        for (i in result.indices) result[i] = values[i]!![column]

        return result
    }

    fun extractColumn(values: kotlin.Array<FloatArray?>, column: Int): FloatArray {
        val result = FloatArray(values.size)
        for (i in result.indices) result[i] = values[i]!![column]

        return result
    }

    fun extractColumns(values: kotlin.Array<FloatArray?>, indices: IntArray): kotlin.Array<FloatArray?> {
        val result = kotlin.arrayOfNulls<FloatArray>(values.size)
        for (i in result.indices) result[i] = Array.extract(values[i]!!, indices)

        return result
    }

    fun extractColumns(values: kotlin.Array<DoubleArray?>, indices: IntArray): kotlin.Array<DoubleArray?> {
        val result = kotlin.arrayOfNulls<DoubleArray>(values.size)
        for (i in result.indices) result[i] = Array.extract(values[i]!!, indices)

        return result
    }

    fun extractColumns(values: kotlin.Array<BooleanArray?>, indices: IntArray): kotlin.Array<BooleanArray?> {
        val result = kotlin.arrayOfNulls<BooleanArray>(values.size)
        for (i in result.indices) result[i] = Array.extract(values[i]!!, indices)

        return result
    }

    fun extractValids(values: FloatArray): FloatArray {
        var count = 0
        for (i in values.indices) if (!isNaN(values[i])) count++

        val result = FloatArray(count)
        count = 0
        for (i in values.indices) if (!isNaN(values[i])) result[count++] = values[i]

        return result
    }

    fun extract(values: IntArray, indices: IntArray): IntArray {
        val result = IntArray(indices.size)
        for (i in result.indices) result[i] = values[indices[i]]

        return result
    }

    fun lengths(arrays: kotlin.Array<FloatArray?>): IntArray {
        val result = IntArray(arrays.size)
        for (i in arrays.indices) result[i] = arrays[i]!!.size

        return result
    }

    fun lengths(arrays: kotlin.Array<IntArray?>): IntArray {
        val result = IntArray(arrays.size)
        for (i in arrays.indices) result[i] = arrays[i]!!.size

        return result
    }

    fun concatenate(xs: FloatArray, ys: FloatArray): FloatArray {
        val result = FloatArray(xs.size + ys.size)
        arraycopy(xs, 0, result, 0, xs.size)
        arraycopy(ys, 0, result, xs.size, ys.size)
        return result
    }

    fun concatenate(xs: DoubleArray, ys: DoubleArray): DoubleArray {
        val result = DoubleArray(xs.size + ys.size)
        arraycopy(xs, 0, result, 0, xs.size)
        arraycopy(ys, 0, result, xs.size, ys.size)
        return result
    }

    fun concatenate(xs: kotlin.Array<FloatArray?>): FloatArray {
        var num = 0
        for (i in xs.indices) num += xs[i]!!.size

        val result = FloatArray(num)
        num = 0
        for (i in xs.indices) {
            arraycopy(xs[i]!!, 0, result, num, xs[i]!!.size)
            num += xs[i]!!.size
        }

        return result
    }

    fun concatenate(xs: kotlin.Array<IntArray?>): IntArray {
        var num = 0
        for (i in xs.indices) num += xs[i]!!.size

        val result = IntArray(num)
        num = 0
        for (i in xs.indices) {
            arraycopy(xs[i]!!, 0, result, num, xs[i]!!.size)
            num += xs[i]!!.size
        }

        return result
    }

    fun concatenate(xs: IntArray, ys: IntArray): IntArray {
        val result = IntArray(xs.size + ys.size)
        arraycopy(xs, 0, result, 0, xs.size)
        arraycopy(ys, 0, result, xs.size, ys.size)
        return result
    }

    fun concatenate(xs: IntArray, y: Int): IntArray {
        val result = IntArray(xs.size + 1)
        arraycopy(xs, 0, result, 0, xs.size)
        result[xs.size] = y
        return result
    }

//    fun concatenate(first: kotlin.Array<Any?>, last: kotlin.Array<Any?>): kotlin.Array<Any?> {
//        val firstContentType: java.lang.Class? = first.javaClass.getComponentType()
//        val lastContentType: java.lang.Class? = last.javaClass.getComponentType()
//        val targetClass: java.lang.Class = getMostSpecificCommonClass(firstContentType, lastContentType)
//        val result = java.lang.reflect.Array.newInstance(targetClass, first.size + last.size) as kotlin.Array<Any?>
//        arraycopy(first, 0, result, 0, first.size)
//        arraycopy(last, 0, result, first.size, last.size)
//        return result
//    }

//    fun getMostSpecificCommonClass(one: java.lang.Class, two: java.lang.Class): java.lang.Class {
//        if (one == two) return one
//        if (one.isAssignableFrom(two)) return one
//        if (two.isAssignableFrom(one)) return two
//        else return getMostSpecificCommonClass(one.getSuperclass(), two.getSuperclass())
//    }

    fun findValids(data: FloatArray): IntArray {
        val result = IntArray(data.size)
        var validCount = 0
        for (i in data.indices) if (!isNaN(data[i])) result[validCount++] = i

        return trim(result, validCount)
    }

    fun findPositives(data: FloatArray): IntArray {
        val result = IntArray(data.size)
        var validCount = 0
        for (i in data.indices) if (data[i] > 0.0f) result[validCount++] = i

        return trim(result, validCount)
    }

    fun findNegatives(data: FloatArray): IntArray {
        val result = IntArray(data.size)
        var validCount = 0
        for (i in data.indices) if (data[i] < 0.0f) result[validCount++] = i

        return trim(result, validCount)
    }

    fun findInvalids(data: FloatArray): IntArray {
        val result = IntArray(data.size)
        var validCount = 0
        for (i in data.indices) if (isNaN(data[i])) result[validCount++] = i

        return trim(result, validCount)
    }

    fun findValids(xs: FloatArray, ys: FloatArray, minValids: Int): IntArray {
        val result = IntArray(xs.size)
        var validCount = 0
        for (i in xs.indices) if (!isNaN(xs[i]) && !isNaN(ys[i])) result[validCount++] =
            i

        return if (validCount >= minValids) trim(result, validCount) else IntArray(0)
    }

    fun findValids(data: FloatArray, minValids: Int): IntArray {
        val result = IntArray(data.size)
        var validCount = 0
        for (i in data.indices) if (!isNaN(data[i])) result[validCount++] = i

        return if (validCount >= minValids) trim(result, validCount) else IntArray(0)
    }

    fun findValids(xs: FloatArray, ys: FloatArray): IntArray {
        val result = IntArray(xs.size)
        var validCount = 0
        for (i in xs.indices) if (!isNaN(xs[i]) && !isNaN(ys[i])) result[validCount++] =
            i

        return trim(result, validCount)
    }

    fun findValids(data: kotlin.Array<FloatArray?>, minValids: Int): IntArray {
        val valids = IntArray(data.size)
        var validCount = 0
        for (row in data.indices) {
            var validsInRow = 0
            for (col in data[row]!!.indices) if (!isNaN(data[row]!![col])) validsInRow++

            if (validsInRow >= minValids) valids[validCount++] = row
        }

        return trim(valids, validCount)
    }

    fun findColumnValids(data: kotlin.Array<FloatArray?>, minValids: Int): IntArray {
        val valids = IntArray(data[0]!!.size)
        var validCount = 0
        for (col in data[0]!!.indices) {
            var validsInColumn = 0
            for (row in data.indices) if (!isNaN(data[row]!![col])) validsInColumn++

            if (validsInColumn >= minValids) valids[validCount++] = col
        }

        return trim(valids, validCount)
    }

    fun findValids(data: FloatArray, start: Int, length: Int): IntArray {
        var length = length
        length = min(length, data.size - start)
        val result = IntArray(length)
        var validCount = 0
        for (i in start..<start + length) if (!isNaN(data[i])) result[validCount++] = i

        return trim(result, validCount)
    }

//    fun intersect(a: IntArray, b: IntArray): IntArray {
//        var a = a
//        var b = b
//        if (b.size == 0 || a.size == 0) return IntArray(0)
//        if (a.size < b.size) {
//            val c = a
//            a = b
//            b = c
//        }
//        val sa = a.clone()
//        java.util.Arrays.sort(sa)
//        val intersection = IntArray(b.size)
//        var intersectionCount = 0
//        for (i in b.indices) if (java.util.Arrays.binarySearch(sa, b[i]) >= 0) intersection[intersectionCount++] = b[i]
//
//        return trim(intersection, intersectionCount)
//    }

    fun trim(strings: kotlin.Array<String?>, len: Int): kotlin.Array<String?> {
        if (strings.size == len) {
            return strings
        } else {
            val truncated = kotlin.arrayOfNulls<String>(len)
            arraycopy(strings, 0, truncated, 0, len)
            return truncated
        }
    }

    fun trim(vector: IntArray, len: Int): IntArray {
        if (vector.size == len) {
            return vector
        } else {
            val truncated = IntArray(len)
            arraycopy(vector, 0, truncated, 0, len)
            return truncated
        }
    }

    fun trim(vector: ByteArray, len: Int): ByteArray {
        if (vector.size == len) {
            return vector
        } else {
            val truncated = ByteArray(len)
            arraycopy(vector, 0, truncated, 0, len)
            return truncated
        }
    }

    fun trim(vector: FloatArray, len: Int): FloatArray {
        if (vector.size == len) {
            return vector
        } else {
            val truncated = FloatArray(len)
            arraycopy(vector, 0, truncated, 0, len)
            return truncated
        }
    }

    fun trim(vector: DoubleArray, len: Int): DoubleArray {
        if (vector.size == len) {
            return vector
        } else {
            val truncated = DoubleArray(len)
            arraycopy(vector, 0, truncated, 0, len)
            return truncated
        }
    }

    fun trim(vector: BooleanArray, len: Int): BooleanArray {
        if (vector.size == len) {
            return vector
        } else {
            val truncated = BooleanArray(len)
            arraycopy(vector, 0, truncated, 0, len)
            return truncated
        }
    }

//    fun trim(vector: kotlin.Array<Any?>, len: Int): kotlin.Array<Any?> {
//        if (vector.size == len) {
//            return vector
//        } else {
//            val truncated =
//                java.lang.reflect.Array.newInstance(vector.javaClass.getComponentType(), len) as kotlin.Array<Any?>
//            arraycopy(vector, 0, truncated, 0, len)
//            return truncated
//        }
//    }

    fun trim(vector: FloatArray, length: Int, onlyValids: Boolean): FloatArray {
        if (onlyValids) {
            var validCount = 0
            for (i in 0..<length) if (!isNaN(vector[i]) && !isInfinite(vector[i])) validCount++

            val result = FloatArray(validCount)
            validCount = 0
            for (i in 0..<length) if (!isNaN(vector[i]) && !isInfinite(vector[i])) result[validCount++] =
                vector[i]

            return result
        } else {
            return trim(vector, length)
        }
    }

    fun trim(vector: kotlin.Array<BooleanArray?>, len: Int): kotlin.Array<BooleanArray?> {
        if (vector.size == len) {
            return vector
        } else {
            val truncated = kotlin.arrayOfNulls<BooleanArray>(len)
            arraycopy(vector, 0, truncated, 0, len)
            return truncated
        }
    }

    fun trim(vector: kotlin.Array<FloatArray?>, len: Int): kotlin.Array<FloatArray?> {
        if (vector.size == len) {
            return vector
        } else {
            val truncated = kotlin.arrayOfNulls<FloatArray>(len)
            arraycopy(vector, 0, truncated, 0, len)
            return truncated
        }
    }

    fun intsToFloats(values: IntArray): FloatArray {
        val result = FloatArray(values.size)
        for (i in values.indices) result[i] = values[i].toFloat()

        return result
    }

    fun intsToFloats(values: kotlin.Array<IntArray?>): kotlin.Array<FloatArray?> {
        val result = kotlin.arrayOfNulls<FloatArray>(values.size)
        for (i in values.indices) result[i] = Array.intsToFloats(values[i]!!)

        return result
    }

    fun floatToBytes(data: kotlin.Array<FloatArray?>): kotlin.Array<ByteArray?> {
        val rowCount = data.size
        val colCount = data[0]!!.size
        val bdata = Array<ByteArray?>(rowCount) { ByteArray(colCount) }
        for (i in 0..<rowCount) {
            for (j in 0..<colCount) bdata[i]!![j] = data[i]!![j].toInt().toByte()
        }

        return bdata
    }

    fun bytesToFloats(values: kotlin.Array<ByteArray?>): kotlin.Array<FloatArray?> {
        val rowCount = values.size
        val colCount = values[0]!!.size
        val result = Array<FloatArray?>(rowCount) { FloatArray(colCount) }
        for (i in 0..<rowCount) {
            for (j in 0..<colCount) result[i]!![j] = values[i]!![j].toFloat()
        }

        return result
    }

    fun floatsToDoubles(data: kotlin.Array<FloatArray?>): kotlin.Array<DoubleArray?> {
        val rowCount = data.size
        val colCount = data[0]!!.size
        val ddata = Array<DoubleArray?>(rowCount) { DoubleArray(colCount) }
        for (i in 0..<rowCount) {
            for (j in 0..<colCount) ddata[i]!![j] = data[i]!![j].toDouble()
        }

        return ddata
    }

    fun bytesToDoubles(data: kotlin.Array<ByteArray?>): kotlin.Array<DoubleArray?> {
        val rowCount = data.size
        val colCount = data[0]!!.size
        val ddata = Array<DoubleArray?>(rowCount) { DoubleArray(colCount) }
        for (i in 0..<rowCount) {
            for (j in 0..<colCount) ddata[i]!![j] = data[i]!![j].toDouble()
        }

        return ddata
    }

//    fun unique(indices: IntArray): IntArray {
//        if (indices.size < 2) return indices
//        val sortedSnapshot = indices.clone()
//        java.util.Arrays.sort(sortedSnapshot)
//        var counter = 1
//        var lastVal = sortedSnapshot[0]
//        for (i in 1..<sortedSnapshot.size) if (lastVal != sortedSnapshot[i]) {
//            lastVal = sortedSnapshot[i]
//            sortedSnapshot[counter++] = lastVal
//        }
//
//        val result = IntArray(counter)
//        arraycopy(sortedSnapshot, 0, result, 0, counter)
//        return result
//    }

//    fun unique(values: FloatArray): FloatArray {
//        val len = values.size
//        if (len < 2) return values
//        val sortedSnapshot = values.clone()
//        java.util.Arrays.sort(sortedSnapshot)
//        var counter = 1
//        var lastVal = sortedSnapshot[0]
//        for (i in 1..<len) if (lastVal != sortedSnapshot[i]) {
//            lastVal = sortedSnapshot[i]
//            sortedSnapshot[counter++] = lastVal
//        }
//
//        val result = FloatArray(counter)
//        arraycopy(sortedSnapshot, 0, result, 0, counter)
//        return result
//    }

//    fun complement(indices: IntArray, totalLength: Int): IntArray {
//        require(totalLength >= 0) { "totalLength must be >= 0" }
//        if (indices.size == 0) if (totalLength == 0) return IntArray(0)
//        else return intList(0, totalLength - 1)
//        val u: IntArray = unique(indices)
//        require(u[0] >= 0) { "indices[] contains negative entries" }
//        require(u[u.size - 1] < totalLength) { "indices[] contains entries >= totalLength" }
//        val result = IntArray(totalLength - u.size)
//        var readCounter = 0
//        var writeCounter = 0
//        var currentSearchRow = u[readCounter++]
//        for (i in 0..<totalLength) if (currentSearchRow == i) {
//            if (readCounter < u.size) currentSearchRow = u[readCounter++]
//        } else {
//            result[writeCounter++] = i
//        }
//
//        return result
//    }

    fun reverse(original: IntArray): IntArray {
        val result = IntArray(original.size)
        for (i in result.indices) result[i] = original[original.size - 1 - i]

        return result
    }

    fun reverse(original: FloatArray): FloatArray {
        val len = original.size
        val result = FloatArray(len)
        var i = len
        var j = 0
        while (--i >= 0) {
            result[j] = original[i]
            j++
        }

        return result
    }

//    fun reverse(original: kotlin.Array<Any?>): kotlin.Array<Any?> {
//        val len = original.size
//        val result =
//            java.lang.reflect.Array.newInstance(original.javaClass.getComponentType(), len) as kotlin.Array<Any?>
//        var i = len
//        var j = 0
//        while (--i >= 0) {
//            result[j] = original[i]
//            j++
//        }
//
//        return result
//    }

    fun getMax(data: IntArray): Int {
        var max = -0x80000000
        var i = data.size
        while (--i >= 0) {
            val `val` = data[i]
            if (`val` > max) max = `val`
        }

        return max
    }

    fun getMax(data: FloatArray): Float {
        var max = (-1.0f / 0.0f)
        var i = data.size
        while (--i >= 0) {
            val `val` = data[i]
            if (`val` > max) max = `val`
        }

        return max
    }

    fun getMax(data: DoubleArray): Double {
        var max = (-1.0 / 0.0)
        var i = data.size
        while (--i >= 0) {
            val `val` = data[i]
            if (`val` > max) max = `val`
        }

        return max
    }

    fun getMinMaxAndSmallestPositive(data: FloatArray): FloatArray {
        var min = 3.402823E+038f
        var max = 1.401298E-045f
        var minPos = (1.0f / 0.0f)
        for (i in data.indices) {
            val `val` = data[i]
            if (`val` > max) max = `val`
            if (`val` < min) min = `val`
            if (`val` > 0.0f && `val` < minPos) minPos = `val`
        }

        if (minPos == 3.402823E+038f) minPos = (0.0f / 0.0f)
        return (floatArrayOf(
            min, max, minPos
        ))
    }

    fun getMinMaxAndSmallestPositive(data: kotlin.Array<FloatArray?>): FloatArray {
        var min = (1.0f / 0.0f)
        var max = (-1.0f / 0.0f)
        var minPos = (1.0f / 0.0f)
        for (i in data.indices) {
            for (j in data[0]!!.indices) {
                val `val` = data[i]!![j]
                if (`val` < min) min = `val`
                else if (`val` > max) max = `val`
                if (`val` > 0.0f && `val` < minPos) minPos = `val`
            }
        }

        if (minPos == 3.402823E+038f) minPos = (0.0f / 0.0f)
        return (floatArrayOf(
            min, max, minPos
        ))
    }

    fun getLogMean(data: kotlin.Array<FloatArray?>): Float {
        var sum = 0.0f
        var counter = 0
        for (i in data.indices) {
            for (j in data[0]!!.indices) if (data[i]!![j] > 0.0f) {
                sum += ln(data[i]!![j].toDouble()).toFloat()
                counter++
            }
        }

        if (counter == 0) return (0.0f / 0.0f)
        else return exp((sum / counter.toFloat()).toDouble()).toFloat()
    }

    @Deprecated("Method find is deprecated")
    fun find(array: IntArray, value: Int): Int {
        return indexOf(array, value)
    }

    fun indexOfOrdered(array: FloatArray, order: IntArray, value: Float): Int {
        var lower = 0
        var upper = array.size
        while (upper - lower > 1) {
            val middle = lower + upper shr 1
            if (array[order[middle]] > value) upper = middle
            else lower = middle
        }

        return lower
    }

    fun indexOf(array: IntArray, value: Int): Int {
        var i = array.size
        while (--i >= 0) {
            if (array[i] == value) return i
        }

        return -1
    }

    @JvmOverloads
    fun indexOf(array: FloatArray, value: Float, index: Int = 0): Int {
        var index = index
        val len = array.size
        if (index < 0) index = 0
        else if (index >= len) return -1
        for (i in index..<len) if (array[i] == value) return i

        return -1
    }

    fun indexOf(array: kotlin.Array<String?>, value: String?): Int {
        var i = array.size
        while (--i >= 0) {
            if (array[i] == value) return i
        }

        return -1
    }

    fun indexOf(array: kotlin.Array<Any?>, value: Any?): Int {
        var i = array.size
        while (--i >= 0) {
            if (array[i] === value) return i
        }

        return -1
    }

    fun transpose(data: kotlin.Array<FloatArray?>): kotlin.Array<FloatArray?> {
        val result = Array<FloatArray?>(data[0]!!.size) { FloatArray(data.size) }
        for (i in data.indices) {
            for (j in data[i]!!.indices) result[j]!![i] = data[i]!![j]
        }

        return result
    }

    fun transpose(data: kotlin.Array<DoubleArray?>): kotlin.Array<DoubleArray?> {
        val result = Array<DoubleArray?>(data[0]!!.size) { DoubleArray(data.size) }
        for (i in data.indices) {
            for (j in data[i]!!.indices) result[j]!![i] = data[i]!![j]
        }

        return result
    }

//    fun subArray(input: kotlin.Array<Any?>, beginIndex: Int, endIndex: Int): kotlin.Array<Any?> {
//        if (input == null) throw NullPointerException()
//        val count = input.size
//        if (beginIndex < 0) throw IndexOutOfBoundsException("beginIndex too low: " + beginIndex)
//        if (endIndex > count) throw IndexOutOfBoundsException("endIndex too low: " + endIndex)
//        if (beginIndex > endIndex) throw IndexOutOfBoundsException("end - begin difference too low: " + (endIndex - beginIndex))
//        if (beginIndex == 0 && endIndex == count) return input
//        val contentType: java.lang.Class? = input.javaClass.getComponentType()
//        val newResult = java.lang.reflect.Array.newInstance(contentType, endIndex - beginIndex) as kotlin.Array<Any?>
//        var newIndex = 0
//        for (i in beginIndex..<newResult.size) {
//            newResult[newIndex] = input[i]
//            newIndex++
//        }
//
//        return newResult
//    }

    fun createArray(rows: Int, cols: Int, initial: Float): kotlin.Array<FloatArray?> {
        val result = kotlin.arrayOfNulls<FloatArray>(rows)
        for (i in result.indices) result[i] = createVector(cols, initial)

        return result
    }

    fun createVector(length: Int, initial: Float): FloatArray {
        val result = FloatArray(length) {
            initial
        }
        return result
    }

    fun createVector(length: Int, initial: Int): IntArray {
        val result = IntArray(length) {
            initial
        }
        return result
    }

//    fun rangeCheck(arrayLen: Int, fromIndex: Int, toIndex: Int) {
//        require(fromIndex <= toIndex) { "fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")" }
//        if (fromIndex < 0) throw ArrayIndexOutOfBoundsException(fromIndex)
//        if (toIndex > arrayLen) throw ArrayIndexOutOfBoundsException(toIndex)
//        else return
//    }

    fun mergeSort(src: kotlin.Array<Any?>, dest: kotlin.Array<Any?>, low: Int, high: Int, c: Comparator<Any?>) {
        val length = high - low
        if (length < 7) {
            for (i in low..<high) {
                var j = i
                while (j > low && c.compare(dest[j - 1], dest[j]) > 0) {
                    swap(dest, j, j - 1)
                    j--
                }
            }

            return
        }
        val mid = low + high shr 1
        mergeSort(dest, src, low, mid, c)
        mergeSort(dest, src, mid, high, c)
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            arraycopy(src, low, dest, low, length)
            return
        }
        var i = low
        var p = low
        var q = mid
        while (i < high) {
            if (q >= high || p < mid && c.compare(src[p], src[q]) <= 0) dest[i] = src[p++]
            else dest[i] = src[q++]
            i++
        }
    }

    private fun swap(x: kotlin.Array<Any?>, a: Int, b: Int) {
        val t = x[a]
        x[a] = x[b]
        x[b] = t
    }
}
