/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.properties

import kotlin.reflect.KProperty

/**
 * Defines the requirements for a property that can change.
 */
interface MutableProperty<T> : Property<T> {
    override var value: T

    operator fun getValue(
        thisRef: Any?,
        property: KProperty<*>,
    ): T =
        value

    operator fun setValue(
        thisRef: Any?,
        property: KProperty<*>,
        value: T,
    ) {
        this.value = value
    }

    //    fun bind(source: Property<T?>?)
//    fun bindBidirectional(source: MutableProperty<T?>?)
//    fun setValue(value: T?)

    companion object {
        fun <T> of(value: T): MutableProperty<T> = SimpleProperty(value)
    }
}