package com.macrofocus.common.properties

/**
 * Default data model a property.
 *
 * @param <T> the type of elements that the property can hold
</T> */
class SimpleListProperty<T>(value: Array<T>) : AbstractMutableListProperty<T>(), MutableListProperty<T> {
    private var list: MutableList<T> = ArrayList<T>(value.asList())

    override var value: List<T>
        get() = ArrayList(list)
        set(value) {
//        if(this.value != value) {
            val old = list
            if(value != null) {
                list = ArrayList<T>(value)
            } else {
                list = ArrayList<T>()
            }
            notifyPropertyChanged(PropertyEvent<List<T>>(old, value))
            //        }
        }

    override val size: Int
        get() = list.size

    override fun add(index: Int, element: T) {
        val old = this.value
        this.list.add(index, element)
        val present = this.value
        notifyPropertyChanged(PropertyEvent<List<T>>(old, present))
    }

    override fun append(value: T) {
        val old = this.value
        this.list.add(value)
        val present = this.value
        notifyPropertyChanged(PropertyEvent<List<T>>(old, present))
    }

    override fun removeAt(index: Int): T {
        val old = this.value
        val index = this.list.removeAt(index)
        val present = this.value
        notifyPropertyChanged(PropertyEvent<List<T>>(old, present))

        return index
    }

    override fun toString(): String {
        return "SimpleListProperty{" +
                "value=" + value +
                '}'
    }

    companion object {
        fun <T> newInstance(value: Array<T>): SimpleListProperty<T> {
            return SimpleListProperty(value)
        }
    }
}
