/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.selection

/**
 * Defines the requirements for a selection that can change.
 */
interface MutableSelection<E> : Selection<E> {
    override var isEnabled: Boolean

    /**
     * Change the selection to the empty set. If this represents a change to the current selection then notify each
     * listener.
     *
     * @return true, if the set of selected elements was changed.
     */
    fun clearSelection(): Boolean
    fun setSelectedElement(element: E)
    fun setSelectedState(element: E, selected: Boolean)

    /**
     * Set the selection state.
     *
     * @param elements the elements to change
     * @param selected true to have the elements selected, false otherwise
     *
     * @return true, if the set of selected elements was changed.
     */
    fun setSelectedIterableState(elements: Iterable<E>, selected: Boolean): Boolean

    /**
     * Set the selection state.
     *
     * @param selected true to have the elements selected, false otherwise
     * @param elements the elements to change
     *
     * @return true, if the set of selected elements was changed.
     */
    fun setSelectedElementsState(selected: Boolean, vararg elements: E): Boolean
    fun setSelectedElements(vararg elements: E)
    fun setSelectedIterable(elements: Iterable<E>)
}