package com.macrofocus.common.units

abstract class Unit(val name: String, val symbol: String, val ratio: Double) {
    fun convertToBaseUnit(amount: Double) = amount * ratio
    fun convertFromBaseUnit(amount: Double) = amount / ratio

    override fun toString() = symbol
}

/**
 * For units after division, A/B
 */
class QuotientUnit<A: Unit, B: Unit>(a: A, b: B):
    Unit("${a.name}/${b.name}","${a.symbol}/${b.symbol}", a.ratio / b.ratio)

/**
 * Creates a QuotientUnit using the division operator, eg Mile / Hour
 */
operator fun <A: Unit, B: Unit> A.div(other: B) = QuotientUnit(this, other)

/**
 * For units after multiplication
 */
class ProductUnit<A: Unit, B: Unit>(a: A, b: B):
    Unit("${a.name}.${b.name}", "${a.symbol}.${b.symbol}", a.ratio * b.ratio)

/**
 * Create a ProductUnit using multiplication operator, eg Metre * Metre for area
 */
operator fun <A: Unit, B: Unit> A.times(other: B) = ProductUnit(this, other)
