package com.macrofocus.order

import com.macrofocus.common.collection.CollectionFactory.copyOnWriteArrayList

class DefaultVisibleOrder<E>(vararg elements: E) : com.macrofocus.order.AbstractOrder<E>(), MutableVisibleOrder<E> {
    private val all: MutableList<E>
    private val visible: MutableList<E>
    override operator fun get(index: Int): E {
        return visible[index]
    }

    override fun size(): Int {
        return visible.size
    }

    override fun indexOf(element: E): Int {
        return visible.indexOf(element)
    }

    override fun previous(element: E): E? {
        val index = visible.indexOf(element)
        return if (index > 0) visible[index - 1] else null
    }

    override fun next(element: E): E? {
        val index = visible.indexOf(element)
        return if (index < visible.size - 1) visible[index + 1] else null
    }

    override operator fun iterator(): Iterator<E> {
        return visible.iterator()
    }

    override fun sizeAll(): Int {
        return all.size
    }

    override fun getAll(index: Int): E {
        return all[index]
    }

    override fun iterableAll(): Iterable<E> {
        return all
    }

    override fun moveToFirst(element: E) {
        while (indexOf(element) > 0) {
            moveToPrevious(element, false)
        }
    }

    override fun moveToPrevious(element: E, skipHidden: Boolean) {
        if (visible.contains(element)) {
            val index = indexOf(element)
            if (index > 0) {
                if (skipHidden) {
                    throw UnsupportedOperationException()
                    //                E toMoveDown = visible.get(index - 1);
//
//                int downIndex = all.indexOf(toMoveDown);
//                int upIndex = all.indexOf(element);
//
//                for(int i = downIndex; i < upIndex; i++) {
//                    all.set(i, )
//                }
                } else {
                    val i = all.indexOf(element)
                    swap(all, i - 1, i)
                }
                swap(visible, index - 1, index)
                notifyOrderChanged(null)
            }
        }
    }

    override fun moveToNext(element: E, skipHidden: Boolean) {
        if (visible.contains(element)) {
            val index = indexOf(element)
            if (index < visible.size - 1) {
                if (skipHidden) {
                    throw UnsupportedOperationException()
                    //                E toMoveDown = visible.get(index - 1);
//
//                int downIndex = all.indexOf(toMoveDown);
//                int upIndex = all.indexOf(element);
//
//                for(int i = downIndex; i < upIndex; i++) {
//                    all.set(i, )
//                }
                } else {
                    val i = all.indexOf(element)
                    swap(all, i + 1, i)
                }
                swap(visible, index + 1, index)
                notifyOrderChanged(null)
            }
        }
    }

    override fun setOrder(elements: List<E>) {
        for (i in elements.indices) {
            val e = elements[i]
            visible[i] = e
        }
        var j = 0
        for (i in all.indices) {
            val e = all[i]
            if (isVisible(e)) {
                all[i] = elements[j]
                j++
            }
        }
        notifyOrderChanged(null)
    }

    override fun sort(comparator: Comparator<E>?) {}
    operator fun set(all: Iterable<E>, visible: Iterable<E>) {
        val a: MutableList<E> = ArrayList<E>()
        val v: MutableList<E> = ArrayList<E>()
        for (element in all) {
            a.add(element)
        }
        for (element in visible) {
            v.add(element)
        }
        this.all.clear()
        this.all.addAll(a)
        this.visible.clear()
        this.visible.addAll(v)
        notifyOrderChanged(OrderEvent<E>(this, visible))
    }

    override fun add(axisModel: E) {
        visible.add(axisModel)
        all.add(axisModel)
        notifyOrderAdded(OrderEvent<E>(this, axisModel))
    }

    override fun remove(axisModel: E) {
        visible.remove(axisModel)
        all.remove(axisModel)
        notifyOrderRemoved(com.macrofocus.order.OrderEvent<E>(this, axisModel))
    }

    override fun setVisible(element: E, visible: Boolean) {
        if (visible) {
            if (!this.visible.contains(element)) {
                val previous = findPreviousVisible(element)
                if (previous != null) {
                    this.visible.add(this.visible.indexOf(previous) + 1, element)
                } else {
                    this.visible.add(0, element)
                }
                notifyOrderVisibility(com.macrofocus.order.OrderEvent<E>(this, element))
            }
        } else {
            if (this.visible.contains(element)) {
                this.visible.remove(element)
                notifyOrderVisibility(com.macrofocus.order.OrderEvent<E>(this, element))
            }
        }
    }

    override fun show(elements: Iterable<E>) {
        val affected: MutableList<E> = ArrayList<E>()
        for (element in elements) {
            if (!visible.contains(element)) {
                val previous = findPreviousVisible(element)
                if (previous != null) {
                    visible.add(visible.indexOf(previous) + 1, element)
                } else {
                    visible.add(0, element)
                }
                affected.add(element)
            }
        }
        if (affected.size > 0) {
            notifyOrderVisibility(OrderEvent<E>(this, affected))
        }
    }

    override fun hide(elements: Iterable<E>) {
        val affected: MutableList<E> = ArrayList<E>()
        for (element in elements) {
            if (visible.contains(element)) {
                visible.remove(element)
                affected.add(element)
            }
        }
        if (affected.size > 0) {
            notifyOrderVisibility(OrderEvent<E>(this, affected))
        }
    }

    override fun show(vararg elements: E) {
        val affected: MutableList<E> = ArrayList<E>()
        for (element in elements) {
            if (!visible.contains(element)) {
                val previous = findPreviousVisible(element)
                if (previous != null) {
                    visible.add(visible.indexOf(previous) + 1, element)
                } else {
                    visible.add(0, element)
                }
                affected.add(element)
            }
        }
        if (affected.size > 0) {
            notifyOrderVisibility(OrderEvent<E>(this, affected))
        }
    }

    override fun hide(vararg elements: E) {
        val affected: MutableList<E> = ArrayList<E>()
        for (element in elements) {
            if (visible.contains(element)) {
                visible.remove(element)
                affected.add(element)
            }
        }
        if (affected.size > 0) {
            notifyOrderVisibility(OrderEvent<E>(this, affected))
        }
    }

    override fun isVisible(element: E): Boolean {
        return visible.contains(element)
    }

    private fun findPreviousVisible(element: E): E? {
        for (i in all.indexOf(element) - 1 downTo 0) {
            val e = all[i]
            if (isVisible(e)) {
                return e
            }
        }
        return null
    }

    /** Swaps x[a] with x[b].  */
    private fun swap(list: MutableList<E>, a: Int, b: Int) {
        val t = list[a]
        list[a] = list[b]
        list[b] = t
    }

    override fun toString(): String {
        var visible = ""
        run {
            var first = true
            for (s in this.visible) {
                if (!first) {
                    visible += ","
                } else {
                    first = false
                }
                visible += s.toString()
            }
        }
        var all = ""
        run {
            var first = true
            for (s in this.all) {
                if (!first) {
                    all += ","
                } else {
                    first = false
                }
                all += s.toString()
            }
        }
        return "DefaultVisibleOrder{" +
                "visible=" + visible +
                ",all=" + all +
                '}'
    }

    init {
        all = copyOnWriteArrayList<E>()
        visible = copyOnWriteArrayList<E>()
        for (element in elements) {
            all.add(element)
            visible.add(element)
        }
    }
}