/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.filter

import com.macrofocus.common.index.Index

/**
 * Created by luc on 24.04.17.
 */
abstract class AbstractMutableIndexFilter<E> constructor() : AbstractFilter<E>(), MutableIndexFilter<E> {
    override var filteredCount: Int = 0
    protected var index: Index<E>? = null
    override val isActive: Boolean
        get() {
            return filteredCount > 0
        }

    override fun setIndex(index: Index<E>, filtered: Iterable<E>, unfiltered: Iterable<E>, filteredCount: Int) {
        this.index = index
        this.filteredCount = filteredCount
        notifyFilteredChanged(SimpleFilterEvent(this, filtered, unfiltered))
    }
}