package com.macrofocus.common.interval

/**
 * An event that characterizes a change in the current interval.
 */
class BoundedIntervalEvent(
    private val oldMinimum: Double,
    private val oldMaximum: Double,
    private val oldMinimumExtent: Double,
    private val oldMaximumExtent: Double
) {
    private var newMinimum = 0.0
    private var newMaximum = 0.0
    private var newMinimumExtent = 0.0
    private var newMaximumExtent = 0.0
    fun setNewValues(newMinimum: Double, newMaximum: Double, newMinimumExtent: Double, newMaximumExtent: Double) {
        this.newMinimum = newMinimum
        this.newMaximum = newMaximum
        this.newMinimumExtent = newMinimumExtent
        this.newMaximumExtent = newMaximumExtent
    }

//    override fun toString(): String {
//        val sb = StringBuffer("BoundedIntervalEvent{")
//        sb.append("newMinimum=").append(newMinimum)
//        sb.append(", newMaximum=").append(newMaximum)
//        sb.append(", newMinimumExtent=").append(newMinimumExtent)
//        sb.append(", newMaximumExtent=").append(newMaximumExtent)
//        sb.append(", oldMinimum=").append(oldMinimum)
//        sb.append(", oldMaximum=").append(oldMaximum)
//        sb.append(", oldMinimumExtent=").append(oldMinimumExtent)
//        sb.append(", oldMaximumExtent=").append(oldMaximumExtent)
//        sb.append('}')
//        return sb.toString()
//    }
}
