/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.properties
/**
 * A collection of named properties.
 */
interface Properties<K> : Iterable<K> {
    override fun iterator(): Iterator<K>
    fun getProperty(name: K): Property<Any?>?
    fun getValue(name: K): Any?

    /**
     * Add a listener to the list that's notified each time a change to the properties occurs.
     *
     * @param listener the PropertiesListener
     */
    fun addPropertiesListener(listener: PropertiesListener<K>)

    /**
     * Add a listener to the list that's notified each time a change to the properties occurs. The listener will
     * automatically be disposed of should no other object have a reference to it.
     *
     * @param listener the PropertiesListener
     */
    fun addWeakPropertiesListener(listener: PropertiesListener<K>)

    /**
     * Remove a listener to the list that's notified each time a change to the properties occurs.
     *
     * @param listener the SelectionListener
     */
    fun removePropertiesListener(listener: PropertiesListener<K>)
}