package com.macrofocus.common.properties

class TransformedProperty<O, T>(val original: MutableProperty<O>, val forward: (O) -> T, val backward: (T) -> O) :
    AbstractMutableProperty<T>() {
    private val listener = object : PropertyListener<O> {
        override fun propertyChanged(event: PropertyEvent<O>) {
            val oldValue : T = forward.invoke(event.oldValue) // value
            val newValue : T = forward.invoke(event.newValue)
            println("TransformedProperty changed: $oldValue,$newValue -> ${oldValue != newValue}")
            if (oldValue != newValue) {
                // This will go into an infinite loop!
                value = newValue
                notifyPropertyChanged(PropertyEvent(oldValue, newValue))
            }
        }
    }

    init {
        original.addWeakPropertyListener(listener)
    }

    override var value: T = forward.invoke(original.value)
        set(value) {
            println("TransformedProperty set: $value,$field -> ${value != field}")
            if(value != field) {
                field = value
                val newValue : O = backward.invoke(value)
                println("TransformedProperty apply: ${original.value},$newValue -> ${original.value != newValue}")
                if (original.value != newValue) {
                    original.value = newValue
                }
            }
        }
}