/*
 * Copyright (c) 2013 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.hierarchy

object HierarchyHelper {
    fun print(hierarchy: Hierarchy<Any?>, it: Iterable<Any?>) {
        for (o in it) {
            for (i in 0 until hierarchy.getLevel(o)) print(" ")
            println("L" + hierarchy.getLevel(o) + ": " + o.toString())
        }
        println("The hierarchy's depth is " + hierarchy.depth)
        println("The hierarchy has " + hierarchy.getLeafCount(hierarchy.root) + " leaves")
    }

    fun print(hierarchy: Hierarchy<Any?>) {
        print(hierarchy, hierarchy.root!!, 0)
        println("The hierarchy's depth is " + hierarchy.depth)
        println("The hierarchy has " + hierarchy.getLeafCount(hierarchy.root) + " leaves")
    }

    private fun print(hierarchy: Hierarchy<Any?>, parent: Any?, indent: Int) {
        for (i in 0 until indent) print(" ")
        println("L" + hierarchy.getLevel(parent) + ": " + parent.toString())
        for (node in hierarchy.getChildren(parent)!!) {
            print(hierarchy, node, indent + 4)
        }
    }
}