package com.macrofocus.order

interface MutableOrder<E> {
    fun moveToFirst(element: E)
    fun moveToPrevious(element: E, skipHidden: Boolean)
    fun moveToNext(element: E, skipHidden: Boolean)
    fun sort(comparator: Comparator<E>?)
    fun add(axisModel: E)
    fun remove(axisModel: E)
    fun setOrder(elements: List<E>)
}