package com.macrofocus.order

interface Order<E> : Iterable<E> {
    operator fun get(index: Int): E
    fun size(): Int
    fun indexOf(element: E): Int
    fun previous(element: E): E?
    fun next(element: E): E?

    /**
     * Add a listener to the list that's notified each time a change to the order occurs.
     *
     * @param listener the SelectionListener
     */
    fun addOrderListener(listener: com.macrofocus.order.OrderListener<E>)

    /**
     * Add a listener to the list that's notified each time a change to the order occurs. The listener will
     * automatically be disposed of should no other object have a reference to it.
     *
     * @param listener the SelectionListener
     */
    fun addWeakOrderListener(listener: com.macrofocus.order.OrderListener<E>)

    /**
     * Remove a listener to the list that's notified each time a change to the order occurs.
     *
     * @param listener the SelectionListener
     */
    fun removeOrderListener(listener: com.macrofocus.order.OrderListener<E>)
}