package com.macrofocus.common.concurrent

import com.macrofocus.common.command.Future

class CallableFuture<T>(task: Callable<T>) : Future<T> {
    override var isDone: Boolean = false
    private var result: T? = null
    private var exception: Exception? = null

    init {
        try {
            result = task.call()
            isDone = true
        } catch (e: Exception) {
            exception = e
        }
    }

    override fun cancel(mayInterruptIfRunning: Boolean): Boolean {
        return false
    }

    override val isCancelled: Boolean
        get() = false

    override fun get(): T? {
        if (exception != null) {
            throw RuntimeException(exception)
        } else {
            return result
        }
    }
}
