package com.macrofocus.common.json

/**
 * Represents a Json array.
 */
interface JsonArray : JsonValue {
    /**
     * Return the ith element of the array.
     */
    operator fun <T : JsonValue?> get(index: Int): T

    /**
     * Return the ith element of the array (uncoerced) as a JsonArray. If the type is not an array,
     * this can result in runtime errors.
     */
    fun getArray(index: Int): JsonArray?

    /**
     * Return the ith element of the array (uncoerced) as a boolean. If the type is not a boolean,
     * this can result in runtime errors.
     */
    fun getBoolean(index: Int): Boolean

    /**
     * Return the ith element of the array (uncoerced) as a number. If the type is not a number, this
     * can result in runtime errors.
     */
    fun getNumber(index: Int): Double

    /**
     * Return the ith element of the array (uncoerced) as a JsonObject If the type is not an object,,
     * this can result in runtime errors.
     */
    fun getObject(index: Int): JsonObject?

    /**
     * Return the ith element of the array (uncoerced) as a String. If the type is not a String, this
     * can result in runtime errors.
     */
    fun getString(index: Int): String?

    /**
     * Length of the array.
     */
    fun length(): Int

    /**
     * Remove an element of the array at a particular index.
     */
    fun remove(index: Int)

    /**
     * Set the value at index to be a given value.
     */
    operator fun set(index: Int, value: JsonValue?)

    /**
     * Set the value at index to be a String value.
     */
    operator fun set(index: Int, string: String)

    /**
     * Set the value at index to be a number value.
     */
    operator fun set(index: Int, number: Double)

    /**
     * Set the value at index to be a boolean value.
     */
    operator fun set(index: Int, bool: Boolean)
}