/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.common.properties

import kotlin.properties.Delegates

/**
 * Default data model a property.
 *
 * @param <T> the type of elements that the property can hold <T>
*/
class SimpleProperty<T>(value: T) : AbstractMutableProperty<T>(), MutableProperty<T> {
    override var value: T by Delegates.observable(value) { property, old, new ->
        if(old != new) {
            notifyPropertyChanged(PropertyEvent(old, new))
        }
    }

//    override var value: T?
//        var internal: T? = value
//
//        get() = this.value
//        set(value) {
//            if (this.value !== value) {
//                val old = this.value
//                this.value = value
//                notifyPropertyChanged(PropertyEvent<T?>(old, value))
//            }
//        }
//

    override fun toString(): String {
        return "SimpleProperty{" +
                "value=" + value +
                '}'
    }

    companion object {
        fun <T> newInstance(value: T): SimpleProperty<T> {
            return SimpleProperty(value)
        }
    }

}